/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.Preconditions;

public abstract class AbstractExecutionGraphHandler<R extends ResponseBody, M extends JobMessageParameters>
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, R, M> {
    private final ExecutionGraphCache executionGraphCache;
    private final Executor executor;

    protected AbstractExecutionGraphHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, MessageHeaders<EmptyRequestBody, R, M> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor) {
        super(localRestAddress, leaderRetriever, timeout, messageHeaders);
        this.executionGraphCache = (ExecutionGraphCache)Preconditions.checkNotNull((Object)executionGraphCache);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    @Override
    protected CompletableFuture<R> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody, M> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
        CompletableFuture<AccessExecutionGraph> executionGraphFuture = this.executionGraphCache.getExecutionGraph(jobId, gateway);
        return executionGraphFuture.thenApplyAsync(executionGraph -> {
            try {
                return this.handleRequest(request, (AccessExecutionGraph)executionGraph);
            }
            catch (RestHandlerException rhe) {
                throw new CompletionException((Throwable)((Object)rhe));
            }
        }, this.executor);
    }

    protected abstract R handleRequest(HandlerRequest<EmptyRequestBody, M> var1, AccessExecutionGraph var2) throws RestHandlerException;
}

