/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import org.apache.flink.runtime.rest.handler.util.HandlerUtils;
import org.apache.flink.runtime.rest.messages.ErrorResponseBody;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;

@ChannelHandler.Sharable
public class PipelineErrorHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private final Logger logger;

    public PipelineErrorHandler(Logger logger) {
        this.logger = logger;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest message) {
        this.logger.warn("Unknown message received: {}", (Object)message);
        HandlerUtils.sendErrorResponse(ctx, message, new ErrorResponseBody("Bad request received."), HttpResponseStatus.BAD_REQUEST);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.logger.warn("Unhandled exception", cause);
    }
}

