/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.LegacyRestHandler;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.Preconditions;

public class LegacyRestHandlerAdapter<T extends RestfulGateway, R extends ResponseBody, M extends MessageParameters>
extends AbstractRestHandler<T, EmptyRequestBody, R, M> {
    private final LegacyRestHandler<T, R, M> legacyRestHandler;

    public LegacyRestHandlerAdapter(CompletableFuture<String> localRestAddress, GatewayRetriever<T> leaderRetriever, Time timeout, MessageHeaders<EmptyRequestBody, R, M> messageHeaders, LegacyRestHandler<T, R, M> legacyRestHandler) {
        super(localRestAddress, leaderRetriever, timeout, messageHeaders);
        this.legacyRestHandler = (LegacyRestHandler)Preconditions.checkNotNull(legacyRestHandler);
    }

    @Override
    protected CompletableFuture<R> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody, M> request, @Nonnull T gateway) throws RestHandlerException {
        return this.legacyRestHandler.handleRequest(request, gateway);
    }
}

