/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.rest.RestServerEndpointConfiguration;
import org.apache.flink.runtime.rest.handler.PipelineErrorHandler;
import org.apache.flink.runtime.rest.handler.RestHandlerSpecification;
import org.apache.flink.runtime.rest.handler.RouterHandler;
import org.apache.flink.shaded.netty4.io.netty.bootstrap.ServerBootstrap;
import org.apache.flink.shaded.netty4.io.netty.channel.Channel;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFuture;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInitializer;
import org.apache.flink.shaded.netty4.io.netty.channel.EventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.socket.SocketChannel;
import org.apache.flink.shaded.netty4.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpObjectAggregator;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpServerCodec;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.router.Router;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslHandler;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestServerEndpoint {
    public static final int MAX_REQUEST_SIZE_BYTES = 0xA00000;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Object lock = new Object();
    private final String configuredAddress;
    private final int configuredPort;
    private final SSLEngine sslEngine;
    private ServerBootstrap bootstrap;
    private Channel serverChannel;
    private String restAddress;
    private volatile boolean started;

    public RestServerEndpoint(RestServerEndpointConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        this.configuredAddress = configuration.getEndpointBindAddress();
        this.configuredPort = configuration.getEndpointBindPort();
        this.sslEngine = configuration.getSslEngine();
        this.restAddress = null;
        this.started = false;
    }

    protected abstract Collection<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> initializeHandlers(CompletableFuture<String> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.log.info("Starting rest endpoint.");
            final Router router = new Router();
            CompletableFuture<String> restAddressFuture = new CompletableFuture<String>();
            this.initializeHandlers(restAddressFuture).forEach(handler -> RestServerEndpoint.registerHandler(router, (Tuple2<RestHandlerSpecification, ChannelInboundHandler>)handler));
            ChannelInitializer<SocketChannel> initializer = new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    RouterHandler handler = new RouterHandler(router);
                    if (RestServerEndpoint.this.sslEngine != null) {
                        ch.pipeline().addLast("ssl", (ChannelHandler)new SslHandler(RestServerEndpoint.this.sslEngine));
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(0xA00000)}).addLast(handler.name(), (ChannelHandler)handler).addLast(new ChannelHandler[]{new PipelineErrorHandler(RestServerEndpoint.this.log)});
                }
            };
            NioEventLoopGroup bossGroup = new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory("flink-rest-server-netty-boss"));
            NioEventLoopGroup workerGroup = new NioEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("flink-rest-server-netty-worker"));
            this.bootstrap = new ServerBootstrap();
            ((ServerBootstrap)this.bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)initializer);
            ChannelFuture channel = this.configuredAddress == null ? this.bootstrap.bind(this.configuredPort) : this.bootstrap.bind(this.configuredAddress, this.configuredPort);
            this.serverChannel = channel.syncUninterruptibly().channel();
            InetSocketAddress bindAddress = (InetSocketAddress)this.serverChannel.localAddress();
            String address = bindAddress.getAddress().getHostAddress();
            int port = bindAddress.getPort();
            this.log.info("Rest endpoint listening at {}:{}", (Object)address, (Object)port);
            String protocol = this.sslEngine != null ? "https://" : "http://";
            this.restAddress = protocol + address + ':' + port;
            restAddressFuture.complete(this.restAddress);
            this.started = true;
        }
    }

    public InetSocketAddress getServerAddress() {
        Preconditions.checkState((boolean)this.started, (Object)"The RestServerEndpoint has not been started yet.");
        Channel server = this.serverChannel;
        if (server != null) {
            try {
                return (InetSocketAddress)server.localAddress();
            }
            catch (Exception e) {
                this.log.error("Cannot access local server address", (Throwable)e);
            }
        }
        return null;
    }

    public String getRestAddress() {
        Preconditions.checkState((boolean)this.started, (Object)"The RestServerEndpoint has not been started yet.");
        return this.restAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(Time timeout) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.log.info("Shutting down rest endpoint.");
            CompletableFuture channelFuture = new CompletableFuture();
            if (this.serverChannel != null) {
                this.serverChannel.close().addListener(ignored -> channelFuture.complete(null));
                this.serverChannel = null;
            }
            CompletableFuture groupFuture = new CompletableFuture();
            CompletableFuture childGroupFuture = new CompletableFuture();
            channelFuture.thenRun(() -> {
                if (this.bootstrap != null) {
                    if (this.bootstrap.group() != null) {
                        this.bootstrap.group().shutdownGracefully(0L, timeout.toMilliseconds(), TimeUnit.MILLISECONDS).addListener(ignored -> groupFuture.complete(null));
                    }
                    if (this.bootstrap.childGroup() != null) {
                        this.bootstrap.childGroup().shutdownGracefully(0L, timeout.toMilliseconds(), TimeUnit.MILLISECONDS).addListener(ignored -> childGroupFuture.complete(null));
                    }
                    this.bootstrap = null;
                } else {
                    groupFuture.complete(null);
                    childGroupFuture.complete(null);
                }
            });
            try {
                CompletableFuture.allOf(groupFuture, childGroupFuture).get(timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
                this.log.info("Rest endpoint shutdown complete.");
            }
            catch (Exception e) {
                this.log.warn("Rest endpoint shutdown failed.", (Throwable)e);
            }
            this.restAddress = null;
            this.started = false;
        }
    }

    private static void registerHandler(Router router, Tuple2<RestHandlerSpecification, ChannelInboundHandler> specificationHandler) {
        switch (((RestHandlerSpecification)specificationHandler.f0).getHttpMethod()) {
            case GET: {
                router.GET(((RestHandlerSpecification)specificationHandler.f0).getTargetRestEndpointURL(), specificationHandler.f1);
                break;
            }
            case POST: {
                router.POST(((RestHandlerSpecification)specificationHandler.f0).getTargetRestEndpointURL(), specificationHandler.f1);
                break;
            }
            case DELETE: {
                router.DELETE(((RestHandlerSpecification)specificationHandler.f0).getTargetRestEndpointURL(), specificationHandler.f1);
                break;
            }
            case PATCH: {
                router.PATCH(((RestHandlerSpecification)specificationHandler.f0).getTargetRestEndpointURL(), specificationHandler.f1);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported http method: " + (Object)((Object)((RestHandlerSpecification)specificationHandler.f0).getHttpMethod()) + '.');
            }
        }
    }
}

