/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.net.SSLUtils;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.Preconditions;

public final class RestClientConfiguration {
    @Nullable
    private final SSLEngine sslEngine;

    private RestClientConfiguration(@Nullable SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }

    public SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    public static RestClientConfiguration fromConfiguration(Configuration config) throws ConfigurationException {
        Preconditions.checkNotNull((Object)config);
        SSLEngine sslEngine = null;
        boolean enableSSL = config.getBoolean(SecurityOptions.SSL_ENABLED);
        if (enableSSL) {
            try {
                SSLContext sslContext = SSLUtils.createSSLServerContext(config);
                if (sslContext != null) {
                    sslEngine = sslContext.createSSLEngine();
                    SSLUtils.setSSLVerAndCipherSuites(sslEngine, config);
                    sslEngine.setUseClientMode(false);
                }
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to initialize SSLContext for the web frontend", (Throwable)e);
            }
        }
        return new RestClientConfiguration(sslEngine);
    }
}

