/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.queryablestate.KvStateID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.util.Preconditions;

public class TaskKvStateRegistry {
    private final KvStateRegistry registry;
    private final JobID jobId;
    private final JobVertexID jobVertexId;
    private final List<KvStateInfo> registeredKvStates = new ArrayList<KvStateInfo>();

    TaskKvStateRegistry(KvStateRegistry registry, JobID jobId, JobVertexID jobVertexId) {
        this.registry = (KvStateRegistry)Preconditions.checkNotNull((Object)registry, (String)"KvStateRegistry");
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId, (String)"JobID");
        this.jobVertexId = (JobVertexID)((Object)Preconditions.checkNotNull((Object)((Object)jobVertexId), (String)"JobVertexID"));
    }

    public void registerKvState(KeyGroupRange keyGroupRange, String registrationName, InternalKvState<?> kvState) {
        KvStateID kvStateId = this.registry.registerKvState(this.jobId, this.jobVertexId, keyGroupRange, registrationName, kvState);
        this.registeredKvStates.add(new KvStateInfo(keyGroupRange, registrationName, kvStateId));
    }

    public void unregisterAll() {
        for (KvStateInfo kvState : this.registeredKvStates) {
            this.registry.unregisterKvState(this.jobId, this.jobVertexId, kvState.keyGroupRange, kvState.registrationName, kvState.kvStateId);
        }
    }

    private static class KvStateInfo {
        private final KeyGroupRange keyGroupRange;
        private final String registrationName;
        private final KvStateID kvStateId;

        public KvStateInfo(KeyGroupRange keyGroupRange, String registrationName, KvStateID kvStateId) {
            this.keyGroupRange = keyGroupRange;
            this.registrationName = registrationName;
            this.kvStateId = kvStateId;
        }
    }
}

