/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.query;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.api.common.JobID;
import org.apache.flink.queryablestate.KvStateID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.query.KvStateRegistryListener;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.internal.InternalKvState;

public class KvStateRegistry {
    private final ConcurrentHashMap<KvStateID, InternalKvState<?>> registeredKvStates = new ConcurrentHashMap();
    private final AtomicReference<KvStateRegistryListener> listenerRef = new AtomicReference();

    public void registerListener(KvStateRegistryListener listener) {
        if (!this.listenerRef.compareAndSet(null, listener)) {
            throw new IllegalStateException("Listener already registered.");
        }
    }

    public void unregisterListener() {
        this.listenerRef.set(null);
    }

    public KvStateID registerKvState(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName, InternalKvState<?> kvState) {
        KvStateID kvStateId = new KvStateID();
        if (this.registeredKvStates.putIfAbsent(kvStateId, kvState) == null) {
            KvStateRegistryListener listener = this.listenerRef.get();
            if (listener != null) {
                listener.notifyKvStateRegistered(jobId, jobVertexId, keyGroupRange, registrationName, kvStateId);
            }
            return kvStateId;
        }
        throw new IllegalStateException("State \"" + registrationName + " \"(id=" + kvStateId + ") appears registered although it should not.");
    }

    public void unregisterKvState(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName, KvStateID kvStateId) {
        KvStateRegistryListener listener;
        if (this.registeredKvStates.remove(kvStateId) != null && (listener = this.listenerRef.get()) != null) {
            listener.notifyKvStateUnregistered(jobId, jobVertexId, keyGroupRange, registrationName);
        }
    }

    public InternalKvState<?> getKvState(KvStateID kvStateId) {
        return this.registeredKvStates.get(kvStateId);
    }

    public TaskKvStateRegistry createTaskRegistry(JobID jobId, JobVertexID jobVertexId) {
        return new TaskKvStateRegistry(this, jobId, jobVertexId);
    }
}

