/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.util.Preconditions;
import scala.concurrent.duration.FiniteDuration;

public class MiniClusterConfiguration {
    private final UnmodifiableConfiguration configuration;
    private final int numJobManagers;
    private final int numTaskManagers;
    private final int numResourceManagers;
    private final RpcServiceSharing rpcServiceSharing;
    @Nullable
    private final String commonBindAddress;

    public MiniClusterConfiguration(Configuration configuration, int numJobManagers, int numTaskManagers, int numResourceManagers, RpcServiceSharing rpcServiceSharing, @Nullable String commonBindAddress) {
        this.configuration = new UnmodifiableConfiguration((Configuration)Preconditions.checkNotNull((Object)configuration));
        this.numJobManagers = numJobManagers;
        this.numTaskManagers = numTaskManagers;
        this.numResourceManagers = numResourceManagers;
        this.rpcServiceSharing = (RpcServiceSharing)((Object)Preconditions.checkNotNull((Object)((Object)rpcServiceSharing)));
        this.commonBindAddress = commonBindAddress;
    }

    public RpcServiceSharing getRpcServiceSharing() {
        return this.rpcServiceSharing;
    }

    public int getNumJobManagers() {
        return this.numJobManagers;
    }

    public int getNumTaskManagers() {
        return this.numTaskManagers;
    }

    public int getNumResourceManagers() {
        return this.numResourceManagers;
    }

    public String getJobManagerBindAddress() {
        return this.commonBindAddress != null ? this.commonBindAddress : this.configuration.getString(JobManagerOptions.ADDRESS, "localhost");
    }

    public String getTaskManagerBindAddress() {
        return this.commonBindAddress != null ? this.commonBindAddress : this.configuration.getString("taskmanager.hostname", "localhost");
    }

    public String getResourceManagerBindAddress() {
        return this.commonBindAddress != null ? this.commonBindAddress : this.configuration.getString(JobManagerOptions.ADDRESS, "localhost");
    }

    public Time getRpcTimeout() {
        FiniteDuration duration = AkkaUtils.getTimeout((Configuration)this.configuration);
        return Time.of((long)duration.length(), (TimeUnit)duration.unit());
    }

    public UnmodifiableConfiguration getConfiguration() {
        return this.configuration;
    }

    public String toString() {
        return "MiniClusterConfiguration {singleRpcService=" + (Object)((Object)this.rpcServiceSharing) + ", numJobManagers=" + this.numJobManagers + ", numTaskManagers=" + this.numTaskManagers + ", numResourceManagers=" + this.numResourceManagers + ", commonBindAddress='" + this.commonBindAddress + '\'' + ", config=" + this.configuration + '}';
    }

    public static class Builder {
        private Configuration configuration = new Configuration();
        private int numJobManagers = 1;
        private int numTaskManagers = 1;
        private int numSlotsPerTaskManager = 1;
        private int numResourceManagers = 1;
        private RpcServiceSharing rpcServiceSharing = RpcServiceSharing.SHARED;
        @Nullable
        private String commonBindAddress = null;

        public Builder setConfiguration(Configuration configuration1) {
            this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration1);
            return this;
        }

        public Builder setNumJobManagers(int numJobManagers) {
            this.numJobManagers = numJobManagers;
            return this;
        }

        public Builder setNumTaskManagers(int numTaskManagers) {
            this.numTaskManagers = numTaskManagers;
            return this;
        }

        public Builder setNumSlotsPerTaskManager(int numSlotsPerTaskManager) {
            this.numSlotsPerTaskManager = numSlotsPerTaskManager;
            return this;
        }

        public Builder setNumResourceManagers(int numResourceManagers) {
            this.numResourceManagers = numResourceManagers;
            return this;
        }

        public Builder setRpcServiceSharing(RpcServiceSharing rpcServiceSharing) {
            this.rpcServiceSharing = (RpcServiceSharing)((Object)Preconditions.checkNotNull((Object)((Object)rpcServiceSharing)));
            return this;
        }

        public Builder setCommonBindAddress(String commonBindAddress) {
            this.commonBindAddress = commonBindAddress;
            return this;
        }

        public MiniClusterConfiguration build() {
            Configuration modifiedConfiguration = new Configuration(this.configuration);
            modifiedConfiguration.setInteger("taskmanager.numberOfTaskSlots", this.numSlotsPerTaskManager);
            return new MiniClusterConfiguration(modifiedConfiguration, this.numJobManagers, this.numTaskManagers, this.numResourceManagers, this.rpcServiceSharing, this.commonBindAddress);
        }
    }

    public static enum RpcServiceSharing {
        SHARED,
        DEDICATED;

    }
}

