/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.webmonitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.messages.webmonitor.InfoMessage;
import org.apache.flink.util.Preconditions;

public class JobsWithIDsOverview
implements InfoMessage {
    private static final long serialVersionUID = -3699051943490133183L;
    private final List<JobID> jobsRunningOrPending;
    private final List<JobID> jobsFinished;
    private final List<JobID> jobsCancelled;
    private final List<JobID> jobsFailed;

    public JobsWithIDsOverview(List<JobID> jobsRunningOrPending, List<JobID> jobsFinished, List<JobID> jobsCancelled, List<JobID> jobsFailed) {
        this.jobsRunningOrPending = (List)Preconditions.checkNotNull(jobsRunningOrPending);
        this.jobsFinished = (List)Preconditions.checkNotNull(jobsFinished);
        this.jobsCancelled = (List)Preconditions.checkNotNull(jobsCancelled);
        this.jobsFailed = (List)Preconditions.checkNotNull(jobsFailed);
    }

    public JobsWithIDsOverview(JobsWithIDsOverview first, JobsWithIDsOverview second) {
        this.jobsRunningOrPending = JobsWithIDsOverview.combine(first.getJobsRunningOrPending(), second.getJobsRunningOrPending());
        this.jobsFinished = JobsWithIDsOverview.combine(first.getJobsFinished(), second.getJobsFinished());
        this.jobsCancelled = JobsWithIDsOverview.combine(first.getJobsCancelled(), second.getJobsCancelled());
        this.jobsFailed = JobsWithIDsOverview.combine(first.getJobsFailed(), second.getJobsFailed());
    }

    public List<JobID> getJobsRunningOrPending() {
        return this.jobsRunningOrPending;
    }

    public List<JobID> getJobsFinished() {
        return this.jobsFinished;
    }

    public List<JobID> getJobsCancelled() {
        return this.jobsCancelled;
    }

    public List<JobID> getJobsFailed() {
        return this.jobsFailed;
    }

    public int hashCode() {
        return this.jobsRunningOrPending.hashCode() ^ this.jobsFinished.hashCode() ^ this.jobsCancelled.hashCode() ^ this.jobsFailed.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JobsWithIDsOverview) {
            JobsWithIDsOverview that = (JobsWithIDsOverview)obj;
            return this.jobsRunningOrPending.equals(that.jobsRunningOrPending) && this.jobsFinished.equals(that.jobsFinished) && this.jobsCancelled.equals(that.jobsCancelled) && this.jobsFailed.equals(that.jobsFailed);
        }
        return false;
    }

    public String toString() {
        return "JobsOverview {numJobsRunningOrPending=" + this.jobsRunningOrPending + ", numJobsFinished=" + this.jobsFinished + ", numJobsCancelled=" + this.jobsCancelled + ", numJobsFailed=" + this.jobsFailed + '}';
    }

    private static ArrayList<JobID> combine(List<JobID> first, List<JobID> second) {
        Preconditions.checkNotNull(first);
        Preconditions.checkNotNull(second);
        ArrayList<JobID> result = new ArrayList<JobID>(first.size() + second.size());
        result.addAll(first);
        result.addAll(second);
        return result;
    }
}

