/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import org.apache.flink.util.Preconditions;

public class LeaderAddressAndId {
    private final String leaderAddress;
    private final UUID leaderId;

    public LeaderAddressAndId(String leaderAddress, UUID leaderId) {
        this.leaderAddress = (String)Preconditions.checkNotNull((Object)leaderAddress);
        this.leaderId = (UUID)Preconditions.checkNotNull((Object)leaderId);
    }

    public String leaderAddress() {
        return this.leaderAddress;
    }

    public UUID leaderId() {
        return this.leaderId;
    }

    public int hashCode() {
        return 31 * this.leaderAddress.hashCode() + this.leaderId.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o.getClass() == LeaderAddressAndId.class) {
            LeaderAddressAndId that = (LeaderAddressAndId)o;
            return this.leaderAddress.equals(that.leaderAddress) && this.leaderId.equals(that.leaderId);
        }
        return false;
    }

    public String toString() {
        return "LeaderAddressAndId (" + this.leaderAddress + " / " + this.leaderId + ')';
    }
}

