/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import scala.concurrent.duration.FiniteDuration;

public class JobManagerServices {
    public final ScheduledExecutorService executorService;
    public final BlobServer blobServer;
    public final BlobLibraryCacheManager libraryCacheManager;
    public final RestartStrategyFactory restartStrategyFactory;
    public final Time rpcAskTimeout;

    public JobManagerServices(ScheduledExecutorService executorService, BlobServer blobServer, BlobLibraryCacheManager libraryCacheManager, RestartStrategyFactory restartStrategyFactory, Time rpcAskTimeout) {
        this.executorService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executorService);
        this.blobServer = (BlobServer)Preconditions.checkNotNull((Object)blobServer);
        this.libraryCacheManager = (BlobLibraryCacheManager)Preconditions.checkNotNull((Object)libraryCacheManager);
        this.restartStrategyFactory = (RestartStrategyFactory)Preconditions.checkNotNull((Object)restartStrategyFactory);
        this.rpcAskTimeout = (Time)Preconditions.checkNotNull((Object)rpcAskTimeout);
    }

    public void shutdown() throws Exception {
        Throwable firstException = null;
        try {
            this.executorService.shutdownNow();
        }
        catch (Throwable t) {
            firstException = t;
        }
        this.libraryCacheManager.shutdown();
        try {
            this.blobServer.close();
        }
        catch (Throwable t) {
            if (firstException == null) {
                firstException = t;
            }
            firstException.addSuppressed(t);
        }
        if (firstException != null) {
            ExceptionUtils.rethrowException((Throwable)firstException, (String)"Error while shutting down JobManager services");
        }
    }

    public static JobManagerServices fromConfiguration(Configuration config, BlobServer blobServer) throws Exception {
        FiniteDuration timeout;
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)blobServer);
        String classLoaderResolveOrder = config.getString(CoreOptions.CLASSLOADER_RESOLVE_ORDER);
        String alwaysParentFirstLoaderString = config.getString(CoreOptions.ALWAYS_PARENT_FIRST_LOADER);
        String[] alwaysParentFirstLoaderPatterns = alwaysParentFirstLoaderString.split(";");
        BlobLibraryCacheManager libraryCacheManager = new BlobLibraryCacheManager(blobServer, FlinkUserCodeClassLoaders.ResolveOrder.fromString(classLoaderResolveOrder), alwaysParentFirstLoaderPatterns);
        try {
            timeout = AkkaUtils.getTimeout(config);
        }
        catch (NumberFormatException e) {
            throw new IllegalConfigurationException(AkkaUtils.formatDurationParingErrorMessage());
        }
        ScheduledExecutorService futureExecutor = Executors.newScheduledThreadPool(Hardware.getNumberCPUCores(), new ExecutorThreadFactory("jobmanager-future"));
        return new JobManagerServices(futureExecutor, blobServer, libraryCacheManager, RestartStrategyFactory.createRestartStrategyFactory(config), Time.of((long)timeout.length(), (TimeUnit)timeout.unit()));
    }
}

