/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.tasks;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.runtime.jobgraph.tasks.ExternalizedCheckpointSettings;
import org.apache.flink.util.Preconditions;

public class CheckpointCoordinatorConfiguration
implements Serializable {
    private static final long serialVersionUID = -647384516034982626L;
    private final long checkpointInterval;
    private final long checkpointTimeout;
    private final long minPauseBetweenCheckpoints;
    private final int maxConcurrentCheckpoints;
    private final ExternalizedCheckpointSettings externalizedCheckpointSettings;
    private final boolean isExactlyOnce;

    public CheckpointCoordinatorConfiguration(long checkpointInterval, long checkpointTimeout, long minPauseBetweenCheckpoints, int maxConcurrentCheckpoints, ExternalizedCheckpointSettings externalizedCheckpointSettings, boolean isExactlyOnce) {
        if (checkpointInterval < 1L || checkpointTimeout < 1L || minPauseBetweenCheckpoints < 0L || maxConcurrentCheckpoints < 1) {
            throw new IllegalArgumentException();
        }
        this.checkpointInterval = checkpointInterval;
        this.checkpointTimeout = checkpointTimeout;
        this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
        this.maxConcurrentCheckpoints = maxConcurrentCheckpoints;
        this.externalizedCheckpointSettings = (ExternalizedCheckpointSettings)Preconditions.checkNotNull((Object)externalizedCheckpointSettings);
        this.isExactlyOnce = isExactlyOnce;
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public long getCheckpointTimeout() {
        return this.checkpointTimeout;
    }

    public long getMinPauseBetweenCheckpoints() {
        return this.minPauseBetweenCheckpoints;
    }

    public int getMaxConcurrentCheckpoints() {
        return this.maxConcurrentCheckpoints;
    }

    public ExternalizedCheckpointSettings getExternalizedCheckpointSettings() {
        return this.externalizedCheckpointSettings;
    }

    public boolean isExactlyOnce() {
        return this.isExactlyOnce;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointCoordinatorConfiguration that = (CheckpointCoordinatorConfiguration)o;
        return this.checkpointInterval == that.checkpointInterval && this.checkpointTimeout == that.checkpointTimeout && this.minPauseBetweenCheckpoints == that.minPauseBetweenCheckpoints && this.maxConcurrentCheckpoints == that.maxConcurrentCheckpoints && this.isExactlyOnce == that.isExactlyOnce && Objects.equals(this.externalizedCheckpointSettings, that.externalizedCheckpointSettings);
    }

    public int hashCode() {
        return Objects.hash(this.checkpointInterval, this.checkpointTimeout, this.minPauseBetweenCheckpoints, this.maxConcurrentCheckpoints, this.externalizedCheckpointSettings, this.isExactlyOnce);
    }

    public String toString() {
        return "JobCheckpointingConfiguration{checkpointInterval=" + this.checkpointInterval + ", checkpointTimeout=" + this.checkpointTimeout + ", minPauseBetweenCheckpoints=" + this.minPauseBetweenCheckpoints + ", maxConcurrentCheckpoints=" + this.maxConcurrentCheckpoints + ", externalizedCheckpointSettings=" + this.externalizedCheckpointSettings + '}';
    }
}

