/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

public enum ResultPartitionType {
    BLOCKING(false, false, false, false),
    PIPELINED(true, true, false, false),
    PIPELINED_BOUNDED(true, true, true, false),
    PIPELINED_CREDIT_BASED(true, true, true, true);

    private final boolean isPipelined;
    private final boolean hasBackPressure;
    private final boolean isBounded;
    private final boolean isCreditBased;

    private ResultPartitionType(boolean isPipelined, boolean hasBackPressure, boolean isBounded, boolean isCreditBased) {
        this.isPipelined = isPipelined;
        this.hasBackPressure = hasBackPressure;
        this.isBounded = isBounded;
        this.isCreditBased = isCreditBased;
    }

    public boolean hasBackPressure() {
        return this.hasBackPressure;
    }

    public boolean isBlocking() {
        return !this.isPipelined;
    }

    public boolean isPipelined() {
        return this.isPipelined;
    }

    public boolean isBounded() {
        return this.isBounded;
    }

    public boolean isCreditBased() {
        return this.isCreditBased;
    }
}

