/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.util.Preconditions;

public class ResultPartitionMetrics {
    private final ResultPartition partition;

    private ResultPartitionMetrics(ResultPartition partition) {
        this.partition = (ResultPartition)Preconditions.checkNotNull((Object)partition);
    }

    long refreshAndGetTotal() {
        long total = 0L;
        for (ResultSubpartition part : this.partition.getAllPartitions()) {
            total += (long)part.unsynchronizedGetNumberOfQueuedBuffers();
        }
        return total;
    }

    int refreshAndGetMin() {
        int min = Integer.MAX_VALUE;
        ResultSubpartition[] allPartitions = this.partition.getAllPartitions();
        if (allPartitions.length == 0) {
            return 0;
        }
        for (ResultSubpartition part : allPartitions) {
            int size = part.unsynchronizedGetNumberOfQueuedBuffers();
            min = Math.min(min, size);
        }
        return min;
    }

    int refreshAndGetMax() {
        int max = 0;
        for (ResultSubpartition part : this.partition.getAllPartitions()) {
            int size = part.unsynchronizedGetNumberOfQueuedBuffers();
            max = Math.max(max, size);
        }
        return max;
    }

    float refreshAndGetAvg() {
        ResultSubpartition[] allPartitions;
        long total = 0L;
        for (ResultSubpartition part : allPartitions = this.partition.getAllPartitions()) {
            int size = part.unsynchronizedGetNumberOfQueuedBuffers();
            total += (long)size;
        }
        return (float)total / (float)allPartitions.length;
    }

    private Gauge<Long> getTotalQueueLenGauge() {
        return new Gauge<Long>(){

            public Long getValue() {
                return ResultPartitionMetrics.this.refreshAndGetTotal();
            }
        };
    }

    private Gauge<Integer> getMinQueueLenGauge() {
        return new Gauge<Integer>(){

            public Integer getValue() {
                return ResultPartitionMetrics.this.refreshAndGetMin();
            }
        };
    }

    private Gauge<Integer> getMaxQueueLenGauge() {
        return new Gauge<Integer>(){

            public Integer getValue() {
                return ResultPartitionMetrics.this.refreshAndGetMax();
            }
        };
    }

    private Gauge<Float> getAvgQueueLenGauge() {
        return new Gauge<Float>(){

            public Float getValue() {
                return Float.valueOf(ResultPartitionMetrics.this.refreshAndGetAvg());
            }
        };
    }

    public static void registerQueueLengthMetrics(MetricGroup group, ResultPartition partition) {
        ResultPartitionMetrics metrics = new ResultPartitionMetrics(partition);
        group.gauge("totalQueueLen", metrics.getTotalQueueLenGauge());
        group.gauge("minQueueLen", metrics.getMinQueueLenGauge());
        group.gauge("maxQueueLen", metrics.getMaxQueueLenGauge());
        group.gauge("avgQueueLen", metrics.getAvgQueueLenGauge());
    }
}

