/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

public class ErrorInfo
implements Serializable {
    private static final long serialVersionUID = -6138942031953594202L;
    private final transient Throwable exception;
    private final long timestamp;
    private volatile String exceptionAsString;

    public ErrorInfo(Throwable exception, long timestamp) {
        Preconditions.checkNotNull((Object)exception);
        Preconditions.checkArgument((timestamp > 0L ? 1 : 0) != 0);
        this.exception = exception;
        this.timestamp = timestamp;
    }

    Throwable getException() {
        return this.exception;
    }

    public String getExceptionAsString() {
        if (this.exceptionAsString == null) {
            this.exceptionAsString = ExceptionUtils.stringifyException((Throwable)this.exception);
        }
        return this.exceptionAsString;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.exceptionAsString == null) {
            this.exceptionAsString = ExceptionUtils.stringifyException((Throwable)this.exception);
        }
        out.defaultWriteObject();
    }
}

