/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution.librarycache;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobLibraryCacheManager
implements LibraryCacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(BlobLibraryCacheManager.class);
    private static final ExecutionAttemptID JOB_ATTEMPT_ID = new ExecutionAttemptID(-1L, -1L);
    private final Object lockObject = new Object();
    private final Map<JobID, LibraryCacheEntry> cacheEntries = new HashMap<JobID, LibraryCacheEntry>();
    private final PermanentBlobService blobService;
    private final FlinkUserCodeClassLoaders.ResolveOrder classLoaderResolveOrder;
    private final String[] alwaysParentFirstPatterns;

    public BlobLibraryCacheManager(PermanentBlobService blobService, FlinkUserCodeClassLoaders.ResolveOrder classLoaderResolveOrder, String[] alwaysParentFirstPatterns) {
        this.blobService = (PermanentBlobService)Preconditions.checkNotNull((Object)blobService);
        this.classLoaderResolveOrder = (FlinkUserCodeClassLoaders.ResolveOrder)((Object)Preconditions.checkNotNull((Object)((Object)classLoaderResolveOrder)));
        this.alwaysParentFirstPatterns = alwaysParentFirstPatterns;
    }

    @Override
    public void registerJob(JobID id, Collection<PermanentBlobKey> requiredJarFiles, Collection<URL> requiredClasspaths) throws IOException {
        this.registerTask(id, JOB_ATTEMPT_ID, requiredJarFiles, requiredClasspaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTask(JobID jobId, ExecutionAttemptID task, @Nullable Collection<PermanentBlobKey> requiredJarFiles, @Nullable Collection<URL> requiredClasspaths) throws IOException {
        Preconditions.checkNotNull((Object)jobId, (String)"The JobId must not be null.");
        Preconditions.checkNotNull((Object)((Object)task), (String)"The task execution id must not be null.");
        if (requiredJarFiles == null) {
            requiredJarFiles = Collections.emptySet();
        }
        if (requiredClasspaths == null) {
            requiredClasspaths = Collections.emptySet();
        }
        Object object = this.lockObject;
        synchronized (object) {
            LibraryCacheEntry entry = this.cacheEntries.get(jobId);
            if (entry == null) {
                URL[] urls = new URL[requiredJarFiles.size() + requiredClasspaths.size()];
                int count = 0;
                try {
                    for (PermanentBlobKey key : requiredJarFiles) {
                        urls[count] = this.blobService.getFile(jobId, key).toURI().toURL();
                        ++count;
                    }
                    Iterator<Serializable> iterator = requiredClasspaths.iterator();
                    while (iterator.hasNext()) {
                        URL url;
                        urls[count] = url = (URL)iterator.next();
                        ++count;
                    }
                    this.cacheEntries.put(jobId, new LibraryCacheEntry(requiredJarFiles, requiredClasspaths, urls, task, this.classLoaderResolveOrder, this.alwaysParentFirstPatterns));
                }
                catch (Throwable t) {
                    ExceptionUtils.tryRethrowIOException((Throwable)t);
                    throw new IOException("Library cache could not register the user code libraries.", t);
                }
            } else {
                entry.register(task, requiredJarFiles, requiredClasspaths);
            }
        }
    }

    @Override
    public void unregisterJob(JobID id) {
        this.unregisterTask(id, JOB_ATTEMPT_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterTask(JobID jobId, ExecutionAttemptID task) {
        Preconditions.checkNotNull((Object)jobId, (String)"The JobId must not be null.");
        Preconditions.checkNotNull((Object)((Object)task), (String)"The task execution id must not be null.");
        Object object = this.lockObject;
        synchronized (object) {
            LibraryCacheEntry entry = this.cacheEntries.get(jobId);
            if (entry != null && entry.unregister(task)) {
                this.cacheEntries.remove(jobId);
                entry.releaseClassLoader();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassLoader getClassLoader(JobID jobId) {
        Preconditions.checkNotNull((Object)jobId, (String)"The JobId must not be null.");
        Object object = this.lockObject;
        synchronized (object) {
            LibraryCacheEntry entry = this.cacheEntries.get(jobId);
            if (entry == null) {
                throw new IllegalStateException("No libraries are registered for job " + jobId);
            }
            return entry.getClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfReferenceHolders(JobID jobId) {
        Object object = this.lockObject;
        synchronized (object) {
            LibraryCacheEntry entry = this.cacheEntries.get(jobId);
            return entry == null ? 0 : entry.getNumberOfReferenceHolders();
        }
    }

    int getNumberOfManagedJobs() {
        return this.cacheEntries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.lockObject;
        synchronized (object) {
            for (LibraryCacheEntry entry : this.cacheEntries.values()) {
                entry.releaseClassLoader();
            }
        }
    }

    private static class LibraryCacheEntry {
        private final URLClassLoader classLoader;
        private final Set<ExecutionAttemptID> referenceHolders;
        private final Set<PermanentBlobKey> libraries;
        private final Set<String> classPaths;

        LibraryCacheEntry(Collection<PermanentBlobKey> requiredLibraries, Collection<URL> requiredClasspaths, URL[] libraryURLs, ExecutionAttemptID initialReference, FlinkUserCodeClassLoaders.ResolveOrder classLoaderResolveOrder, String[] alwaysParentFirstPatterns) {
            this.classLoader = FlinkUserCodeClassLoaders.create(classLoaderResolveOrder, libraryURLs, FlinkUserCodeClassLoaders.class.getClassLoader(), alwaysParentFirstPatterns);
            this.classPaths = new HashSet<String>(requiredClasspaths.size());
            for (URL url : requiredClasspaths) {
                this.classPaths.add(url.toString());
            }
            this.libraries = new HashSet<PermanentBlobKey>(requiredLibraries);
            this.referenceHolders = new HashSet<ExecutionAttemptID>();
            this.referenceHolders.add(initialReference);
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public Set<PermanentBlobKey> getLibraries() {
            return this.libraries;
        }

        public void register(ExecutionAttemptID task, Collection<PermanentBlobKey> requiredLibraries, Collection<URL> requiredClasspaths) {
            if (this.libraries.size() != requiredLibraries.size() || !new HashSet<PermanentBlobKey>(requiredLibraries).containsAll(this.libraries)) {
                throw new IllegalStateException("The library registration references a different set of library BLOBs than previous registrations for this job:\nold:" + this.libraries.toString() + "\nnew:" + requiredLibraries.toString());
            }
            if (this.classPaths.size() != requiredClasspaths.size() || !requiredClasspaths.stream().map(URL::toString).collect(Collectors.toSet()).containsAll(this.classPaths)) {
                throw new IllegalStateException("The library registration references a different set of library BLOBs than previous registrations for this job:\nold:" + this.classPaths.toString() + "\nnew:" + requiredClasspaths.toString());
            }
            this.referenceHolders.add(task);
        }

        public boolean unregister(ExecutionAttemptID task) {
            this.referenceHolders.remove((Object)task);
            return this.referenceHolders.isEmpty();
        }

        int getNumberOfReferenceHolders() {
            return this.referenceHolders.size();
        }

        void releaseClassLoader() {
            try {
                this.classLoader.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to release user code class loader for " + Arrays.toString(this.libraries.toArray()));
            }
        }
    }
}

