/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;

public class Executors {
    private static final Logger LOG = LoggerFactory.getLogger(Executors.class);

    public static Executor directExecutor() {
        return DirectExecutor.INSTANCE;
    }

    public static ExecutionContext directExecutionContext() {
        return DirectExecutionContext.INSTANCE;
    }

    public static void gracefulShutdown(long timeout, TimeUnit unit, ExecutorService ... executorServices) {
        for (ExecutorService executorService : executorServices) {
            executorService.shutdown();
        }
        boolean wasInterrupted = false;
        long endTime = unit.toMillis(timeout) + System.currentTimeMillis();
        long timeLeft = unit.toMillis(timeout);
        boolean hasTimeLeft = timeLeft > 0L;
        for (ExecutorService executorService : executorServices) {
            if (wasInterrupted || !hasTimeLeft) {
                executorService.shutdownNow();
                continue;
            }
            try {
                if (!executorService.awaitTermination(timeLeft, TimeUnit.MILLISECONDS)) {
                    LOG.warn("ExecutorService did not terminate in time. Shutting it down now.");
                    executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while shutting down executor services. Shutting all remaining ExecutorServices down now.", (Throwable)e);
                executorService.shutdownNow();
                wasInterrupted = true;
                Thread.currentThread().interrupt();
            }
            timeLeft = endTime - System.currentTimeMillis();
            hasTimeLeft = timeLeft > 0L;
        }
    }

    private static class DirectExecutionContext
    implements ExecutionContext {
        static final DirectExecutionContext INSTANCE = new DirectExecutionContext();

        private DirectExecutionContext() {
        }

        public void execute(Runnable runnable) {
            runnable.run();
        }

        public void reportFailure(Throwable cause) {
            throw new IllegalStateException("Error in direct execution context.", cause);
        }

        public ExecutionContext prepare() {
            return this;
        }
    }

    private static class DirectExecutor
    implements Executor {
        static final DirectExecutor INSTANCE = new DirectExecutor();

        private DirectExecutor() {
        }

        @Override
        public void execute(@Nonnull Runnable command) {
            command.run();
        }
    }
}

