/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.CompositeStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorSubtaskState
implements CompositeStateHandle {
    private static final Logger LOG = LoggerFactory.getLogger(OperatorSubtaskState.class);
    private static final long serialVersionUID = -2394696997971923995L;
    @Nonnull
    private final Collection<OperatorStateHandle> managedOperatorState;
    @Nonnull
    private final Collection<OperatorStateHandle> rawOperatorState;
    @Nonnull
    private final Collection<KeyedStateHandle> managedKeyedState;
    @Nonnull
    private final Collection<KeyedStateHandle> rawKeyedState;
    private final long stateSize;

    public OperatorSubtaskState() {
        this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public OperatorSubtaskState(Collection<OperatorStateHandle> managedOperatorState, Collection<OperatorStateHandle> rawOperatorState, Collection<KeyedStateHandle> managedKeyedState, Collection<KeyedStateHandle> rawKeyedState) {
        this.managedOperatorState = (Collection)Preconditions.checkNotNull(managedOperatorState);
        this.rawOperatorState = (Collection)Preconditions.checkNotNull(rawOperatorState);
        this.managedKeyedState = (Collection)Preconditions.checkNotNull(managedKeyedState);
        this.rawKeyedState = (Collection)Preconditions.checkNotNull(rawKeyedState);
        try {
            long calculateStateSize = OperatorSubtaskState.sumAllSizes(managedOperatorState);
            calculateStateSize += OperatorSubtaskState.sumAllSizes(rawOperatorState);
            calculateStateSize += OperatorSubtaskState.sumAllSizes(managedKeyedState);
            this.stateSize = calculateStateSize += OperatorSubtaskState.sumAllSizes(rawKeyedState);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get state size.", e);
        }
    }

    public OperatorSubtaskState(OperatorStateHandle managedOperatorState, OperatorStateHandle rawOperatorState, KeyedStateHandle managedKeyedState, KeyedStateHandle rawKeyedState) {
        this(OperatorSubtaskState.singletonOrEmptyOnNull(managedOperatorState), OperatorSubtaskState.singletonOrEmptyOnNull(rawOperatorState), OperatorSubtaskState.singletonOrEmptyOnNull(managedKeyedState), OperatorSubtaskState.singletonOrEmptyOnNull(rawKeyedState));
    }

    private static <T> Collection<T> singletonOrEmptyOnNull(T element) {
        return element != null ? Collections.singletonList(element) : Collections.emptyList();
    }

    private static long sumAllSizes(Collection<? extends StateObject> stateObject) throws Exception {
        long size = 0L;
        for (StateObject stateObject2 : stateObject) {
            size += OperatorSubtaskState.getSizeNullSafe(stateObject2);
        }
        return size;
    }

    private static long getSizeNullSafe(StateObject stateObject) throws Exception {
        return stateObject != null ? stateObject.getStateSize() : 0L;
    }

    @Nonnull
    public Collection<OperatorStateHandle> getManagedOperatorState() {
        return this.managedOperatorState;
    }

    @Nonnull
    public Collection<OperatorStateHandle> getRawOperatorState() {
        return this.rawOperatorState;
    }

    @Nonnull
    public Collection<KeyedStateHandle> getManagedKeyedState() {
        return this.managedKeyedState;
    }

    @Nonnull
    public Collection<KeyedStateHandle> getRawKeyedState() {
        return this.rawKeyedState;
    }

    @Override
    public void discardState() {
        try {
            ArrayList<StateObject> toDispose = new ArrayList<StateObject>(this.managedOperatorState.size() + this.rawOperatorState.size() + this.managedKeyedState.size() + this.rawKeyedState.size());
            toDispose.addAll(this.managedOperatorState);
            toDispose.addAll(this.rawOperatorState);
            toDispose.addAll(this.managedKeyedState);
            toDispose.addAll(this.rawKeyedState);
            StateUtil.bestEffortDiscardAllStateObjects(toDispose);
        }
        catch (Exception e) {
            LOG.warn("Error while discarding operator states.", (Throwable)e);
        }
    }

    @Override
    public void registerSharedStates(SharedStateRegistry sharedStateRegistry) {
        OperatorSubtaskState.registerSharedState(sharedStateRegistry, this.managedKeyedState);
        OperatorSubtaskState.registerSharedState(sharedStateRegistry, this.rawKeyedState);
    }

    private static void registerSharedState(SharedStateRegistry sharedStateRegistry, Iterable<KeyedStateHandle> stateHandles) {
        for (KeyedStateHandle stateHandle : stateHandles) {
            if (stateHandle == null) continue;
            stateHandle.registerSharedStates(sharedStateRegistry);
        }
    }

    @Override
    public long getStateSize() {
        return this.stateSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorSubtaskState that = (OperatorSubtaskState)o;
        if (this.getStateSize() != that.getStateSize()) {
            return false;
        }
        if (!this.getManagedOperatorState().equals(that.getManagedOperatorState())) {
            return false;
        }
        if (!this.getRawOperatorState().equals(that.getRawOperatorState())) {
            return false;
        }
        if (!this.getManagedKeyedState().equals(that.getManagedKeyedState())) {
            return false;
        }
        return this.getRawKeyedState().equals(that.getRawKeyedState());
    }

    public int hashCode() {
        int result = this.getManagedOperatorState().hashCode();
        result = 31 * result + this.getRawOperatorState().hashCode();
        result = 31 * result + this.getManagedKeyedState().hashCode();
        result = 31 * result + this.getRawKeyedState().hashCode();
        result = 31 * result + (int)(this.getStateSize() ^ this.getStateSize() >>> 32);
        return result;
    }

    public String toString() {
        return "SubtaskState{operatorStateFromBackend=" + this.managedOperatorState + ", operatorStateFromStream=" + this.rawOperatorState + ", keyedStateFromBackend=" + this.managedKeyedState + ", keyedStateFromStream=" + this.rawKeyedState + ", stateSize=" + this.stateSize + '}';
    }

    public boolean hasState() {
        return this.hasState(this.managedOperatorState) || this.hasState(this.rawOperatorState) || this.hasState(this.managedKeyedState) || this.hasState(this.rawKeyedState);
    }

    private boolean hasState(Iterable<? extends StateObject> states) {
        for (StateObject stateObject : states) {
            if (stateObject == null) continue;
            return true;
        }
        return false;
    }
}

