/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.akka;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.akka.ListeningBehaviour;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.FlinkJobNotFoundException;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.messages.webmonitor.ClusterOverview;
import org.apache.flink.runtime.messages.webmonitor.JobsWithIDsOverview;
import org.apache.flink.runtime.messages.webmonitor.MultipleJobsDetails;
import org.apache.flink.runtime.messages.webmonitor.RequestJobDetails;
import org.apache.flink.runtime.messages.webmonitor.RequestJobsWithIDsOverview;
import org.apache.flink.runtime.messages.webmonitor.RequestStatusOverview;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import scala.Option;
import scala.reflect.ClassTag$;

public class AkkaJobManagerGateway
implements JobManagerGateway {
    private final ActorGateway jobManagerGateway;
    private final String hostname;

    public AkkaJobManagerGateway(ActorGateway jobManagerGateway) {
        this.jobManagerGateway = (ActorGateway)Preconditions.checkNotNull((Object)jobManagerGateway);
        Option optHostname = jobManagerGateway.actor().path().address().host();
        this.hostname = optHostname.isDefined() ? (String)optHostname.get() : "localhost";
    }

    @Override
    public String getAddress() {
        return this.jobManagerGateway.path();
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public CompletableFuture<Integer> requestBlobServerPort(Time timeout) {
        return FutureUtils.toJava(this.jobManagerGateway.ask(JobManagerMessages.getRequestBlobManagerPort(), FutureUtils.toFiniteDuration(timeout)).mapTo(ClassTag$.MODULE$.apply(Integer.class)));
    }

    @Override
    public CompletableFuture<Acknowledge> submitJob(JobGraph jobGraph, ListeningBehaviour listeningBehaviour, Time timeout) {
        return FutureUtils.toJava(this.jobManagerGateway.ask(new JobManagerMessages.SubmitJob(jobGraph, listeningBehaviour), FutureUtils.toFiniteDuration(timeout))).thenApply(response -> {
            if (response instanceof JobManagerMessages.JobSubmitSuccess) {
                JobManagerMessages.JobSubmitSuccess success = (JobManagerMessages.JobSubmitSuccess)response;
                if (Objects.equals(success.jobId(), jobGraph.getJobID())) {
                    return Acknowledge.get();
                }
                throw new CompletionException(new FlinkException("JobManager responded for wrong Job. This Job: " + jobGraph.getJobID() + ", response: " + success.jobId()));
            }
            if (response instanceof JobManagerMessages.JobResultFailure) {
                JobManagerMessages.JobResultFailure failure = (JobManagerMessages.JobResultFailure)response;
                throw new CompletionException(new FlinkException("Job submission failed.", (Throwable)failure.cause()));
            }
            throw new CompletionException(new FlinkException("Unknown response to SubmitJob message: " + response + '.'));
        });
    }

    @Override
    public CompletableFuture<String> cancelJobWithSavepoint(JobID jobId, String savepointPath, Time timeout) {
        CompletableFuture cancellationFuture = FutureUtils.toJava(this.jobManagerGateway.ask(new JobManagerMessages.CancelJobWithSavepoint(jobId, savepointPath), FutureUtils.toFiniteDuration(timeout)).mapTo(ClassTag$.MODULE$.apply(JobManagerMessages.CancellationResponse.class)));
        return cancellationFuture.thenApply(response -> {
            if (response instanceof JobManagerMessages.CancellationSuccess) {
                return ((JobManagerMessages.CancellationSuccess)response).savepointPath();
            }
            throw new CompletionException(new FlinkException("Cancel with savepoint failed.", ((JobManagerMessages.CancellationFailure)response).cause()));
        });
    }

    @Override
    public CompletableFuture<Acknowledge> cancelJob(JobID jobId, Time timeout) {
        CompletableFuture responseFuture = FutureUtils.toJava(this.jobManagerGateway.ask(new JobManagerMessages.CancelJob(jobId), FutureUtils.toFiniteDuration(timeout)).mapTo(ClassTag$.MODULE$.apply(JobManagerMessages.CancellationResponse.class)));
        return responseFuture.thenApply(response -> {
            if (response instanceof JobManagerMessages.CancellationSuccess) {
                return Acknowledge.get();
            }
            throw new CompletionException(new FlinkException("Cancel job failed " + jobId + '.', ((JobManagerMessages.CancellationFailure)response).cause()));
        });
    }

    @Override
    public CompletableFuture<Acknowledge> stopJob(JobID jobId, Time timeout) {
        CompletableFuture responseFuture = FutureUtils.toJava(this.jobManagerGateway.ask(new JobManagerMessages.StopJob(jobId), FutureUtils.toFiniteDuration(timeout)).mapTo(ClassTag$.MODULE$.apply(JobManagerMessages.StoppingResponse.class)));
        return responseFuture.thenApply(response -> {
            if (response instanceof JobManagerMessages.StoppingSuccess) {
                return Acknowledge.get();
            }
            throw new CompletionException(new FlinkException("Stop job failed " + jobId + '.', ((JobManagerMessages.StoppingFailure)response).cause()));
        });
    }

    @Override
    public CompletableFuture<Optional<Instance>> requestTaskManagerInstance(ResourceID resourceId, Time timeout) {
        return FutureUtils.toJava(this.jobManagerGateway.ask(new JobManagerMessages.RequestTaskManagerInstance(resourceId), FutureUtils.toFiniteDuration(timeout)).mapTo(ClassTag$.MODULE$.apply(JobManagerMessages.TaskManagerInstance.class))).thenApply(taskManagerResponse -> {
            if (taskManagerResponse.instance().isDefined()) {
                return Optional.of(taskManagerResponse.instance().get());
            }
            return Optional.empty();
        });
    }

    @Override
    public CompletableFuture<Collection<Instance>> requestTaskManagerInstances(Time timeout) {
        CompletableFuture taskManagersFuture = FutureUtils.toJava(this.jobManagerGateway.ask(JobManagerMessages.getRequestRegisteredTaskManagers(), FutureUtils.toFiniteDuration(timeout)).mapTo(ClassTag$.MODULE$.apply(JobManagerMessages.RegisteredTaskManagers.class)));
        return taskManagersFuture.thenApply(JobManagerMessages.RegisteredTaskManagers::asJavaCollection);
    }

    @Override
    public CompletableFuture<Optional<JobManagerMessages.ClassloadingProps>> requestClassloadingProps(JobID jobId, Time timeout) {
        return FutureUtils.toJava(this.jobManagerGateway.ask(new JobManagerMessages.RequestClassloadingProps(jobId), FutureUtils.toFiniteDuration(timeout))).thenApply(response -> {
            if (response instanceof JobManagerMessages.ClassloadingProps) {
                return Optional.of((JobManagerMessages.ClassloadingProps)response);
            }
            if (response instanceof JobManagerMessages.JobNotFound) {
                return Optional.empty();
            }
            throw new CompletionException(new FlinkException("Unknown response: " + response + '.'));
        });
    }

    @Override
    public CompletableFuture<MultipleJobsDetails> requestJobDetails(boolean includeRunning, boolean includeFinished, Time timeout) {
        return FutureUtils.toJava(this.jobManagerGateway.ask(new RequestJobDetails(true, true), FutureUtils.toFiniteDuration(timeout)).mapTo(ClassTag$.MODULE$.apply(MultipleJobsDetails.class)));
    }

    @Override
    public CompletableFuture<AccessExecutionGraph> requestJob(JobID jobId, Time timeout) {
        CompletableFuture jobResponseFuture = FutureUtils.toJava(this.jobManagerGateway.ask(new JobManagerMessages.RequestJob(jobId), FutureUtils.toFiniteDuration(timeout)).mapTo(ClassTag$.MODULE$.apply(JobManagerMessages.JobResponse.class)));
        return jobResponseFuture.thenApply(jobResponse -> {
            if (jobResponse instanceof JobManagerMessages.JobFound) {
                return ((JobManagerMessages.JobFound)jobResponse).executionGraph();
            }
            throw new CompletionException((Throwable)((Object)new FlinkJobNotFoundException(jobId)));
        });
    }

    @Override
    public CompletableFuture<ClusterOverview> requestClusterOverview(Time timeout) {
        return FutureUtils.toJava(this.jobManagerGateway.ask(RequestStatusOverview.getInstance(), FutureUtils.toFiniteDuration(timeout)).mapTo(ClassTag$.MODULE$.apply(ClusterOverview.class)));
    }

    @Override
    public CompletableFuture<Collection<String>> requestMetricQueryServicePaths(Time timeout) {
        String jobManagerPath = this.getAddress();
        String jobManagerMetricQueryServicePath = jobManagerPath.substring(0, jobManagerPath.lastIndexOf(47) + 1) + "MetricQueryService";
        return CompletableFuture.completedFuture(Collections.singleton(jobManagerMetricQueryServicePath));
    }

    @Override
    public CompletableFuture<Collection<Tuple2<ResourceID, String>>> requestTaskManagerMetricQueryServicePaths(Time timeout) {
        return this.requestTaskManagerInstances(timeout).thenApply(instances -> instances.stream().map(instance -> {
            String taskManagerAddress = instance.getTaskManagerGateway().getAddress();
            String taskManagerMetricQuerServicePath = taskManagerAddress.substring(0, taskManagerAddress.lastIndexOf(47) + 1) + "MetricQueryService" + '_' + instance.getTaskManagerID().getResourceIdString();
            return Tuple2.of((Object)instance.getTaskManagerID(), (Object)taskManagerMetricQuerServicePath);
        }).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<JobsWithIDsOverview> requestJobsOverview(Time timeout) {
        return FutureUtils.toJava(this.jobManagerGateway.ask(RequestJobsWithIDsOverview.getInstance(), FutureUtils.toFiniteDuration(timeout)).mapTo(ClassTag$.MODULE$.apply(JobsWithIDsOverview.class)));
    }

    @Override
    public CompletableFuture<String> requestRestAddress(Time timeout) {
        return FutureUtils.toJava(this.jobManagerGateway.ask(JobManagerMessages.getRequestRestAddress(), FutureUtils.toFiniteDuration(timeout)).mapTo(ClassTag$.MODULE$.apply(String.class)));
    }
}

