/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.scheduler.ExecutionSlotSharingGroup;
import org.apache.flink.runtime.scheduler.SlotSharingStrategy;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.SchedulingResultPartition;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.util.Preconditions;

class LocalInputPreferredSlotSharingStrategy
implements SlotSharingStrategy {
    private final Map<ExecutionVertexID, ExecutionSlotSharingGroup> executionSlotSharingGroupMap;

    LocalInputPreferredSlotSharingStrategy(SchedulingTopology topology, Set<SlotSharingGroup> logicalSlotSharingGroups, Set<CoLocationGroup> coLocationGroups) {
        this.executionSlotSharingGroupMap = new ExecutionSlotSharingGroupBuilder(topology, logicalSlotSharingGroups, coLocationGroups).build();
    }

    @Override
    public ExecutionSlotSharingGroup getExecutionSlotSharingGroup(ExecutionVertexID executionVertexId) {
        return this.executionSlotSharingGroupMap.get(executionVertexId);
    }

    @Override
    public Set<ExecutionSlotSharingGroup> getExecutionSlotSharingGroups() {
        return new HashSet<ExecutionSlotSharingGroup>(this.executionSlotSharingGroupMap.values());
    }

    private static class ExecutionSlotSharingGroupBuilder {
        private final SchedulingTopology topology;
        private final Map<JobVertexID, SlotSharingGroup> slotSharingGroupMap;
        private final Map<JobVertexID, CoLocationGroup> coLocationGroupMap;
        private final Map<ExecutionVertexID, ExecutionSlotSharingGroup> executionSlotSharingGroupMap;
        final Map<CoLocationConstraint, ExecutionSlotSharingGroup> constraintToExecutionSlotSharingGroupMap;
        final Map<SlotSharingGroupId, List<ExecutionSlotSharingGroup>> executionSlotSharingGroups;
        private final Map<ExecutionSlotSharingGroup, Set<JobVertexID>> assignedJobVerticesForGroups;

        private ExecutionSlotSharingGroupBuilder(SchedulingTopology topology, Set<SlotSharingGroup> logicalSlotSharingGroups, Set<CoLocationGroup> coLocationGroups) {
            this.topology = (SchedulingTopology)Preconditions.checkNotNull((Object)topology);
            this.slotSharingGroupMap = new HashMap<JobVertexID, SlotSharingGroup>();
            for (SlotSharingGroup slotSharingGroup : logicalSlotSharingGroups) {
                for (JobVertexID jobVertexId : slotSharingGroup.getJobVertexIds()) {
                    this.slotSharingGroupMap.put(jobVertexId, slotSharingGroup);
                }
            }
            this.coLocationGroupMap = new HashMap<JobVertexID, CoLocationGroup>();
            for (CoLocationGroup coLocationGroup : coLocationGroups) {
                for (JobVertexID jobVertexId : coLocationGroup.getVertexIds()) {
                    this.coLocationGroupMap.put(jobVertexId, coLocationGroup);
                }
            }
            this.executionSlotSharingGroupMap = new HashMap<ExecutionVertexID, ExecutionSlotSharingGroup>();
            this.constraintToExecutionSlotSharingGroupMap = new HashMap<CoLocationConstraint, ExecutionSlotSharingGroup>();
            this.executionSlotSharingGroups = new HashMap<SlotSharingGroupId, List<ExecutionSlotSharingGroup>>();
            this.assignedJobVerticesForGroups = new IdentityHashMap<ExecutionSlotSharingGroup, Set<JobVertexID>>();
        }

        private Map<ExecutionVertexID, ExecutionSlotSharingGroup> build() {
            LinkedHashMap<JobVertexID, List<SchedulingExecutionVertex>> allVertices = this.getExecutionVertices();
            for (List<SchedulingExecutionVertex> executionVertices : allVertices.values()) {
                List<SchedulingExecutionVertex> remaining = this.tryFindOptimalAvailableExecutionSlotSharingGroupFor(executionVertices);
                this.findAvailableOrCreateNewExecutionSlotSharingGroupFor(remaining);
                this.updateConstraintToExecutionSlotSharingGroupMap(executionVertices);
            }
            return this.executionSlotSharingGroupMap;
        }

        private LinkedHashMap<JobVertexID, List<SchedulingExecutionVertex>> getExecutionVertices() {
            LinkedHashMap<JobVertexID, List<SchedulingExecutionVertex>> vertices = new LinkedHashMap<JobVertexID, List<SchedulingExecutionVertex>>();
            for (SchedulingExecutionVertex executionVertex : this.topology.getVertices()) {
                List executionVertexGroup = vertices.computeIfAbsent(((ExecutionVertexID)executionVertex.getId()).getJobVertexId(), k -> new ArrayList());
                executionVertexGroup.add(executionVertex);
            }
            return vertices;
        }

        private List<SchedulingExecutionVertex> tryFindOptimalAvailableExecutionSlotSharingGroupFor(List<SchedulingExecutionVertex> executionVertices) {
            ArrayList<SchedulingExecutionVertex> remaining = new ArrayList<SchedulingExecutionVertex>();
            for (SchedulingExecutionVertex executionVertex : executionVertices) {
                ExecutionSlotSharingGroup group = this.tryFindAvailableCoLocatedExecutionSlotSharingGroupFor(executionVertex);
                if (group == null) {
                    group = this.tryFindAvailableProducerExecutionSlotSharingGroupFor(executionVertex);
                }
                if (group == null) {
                    remaining.add(executionVertex);
                    continue;
                }
                this.addVertexToExecutionSlotSharingGroup(executionVertex, group);
            }
            return remaining;
        }

        private ExecutionSlotSharingGroup tryFindAvailableCoLocatedExecutionSlotSharingGroupFor(SchedulingExecutionVertex executionVertex) {
            ExecutionVertexID executionVertexId = (ExecutionVertexID)executionVertex.getId();
            CoLocationGroup coLocationGroup = this.coLocationGroupMap.get(executionVertexId.getJobVertexId());
            if (coLocationGroup != null) {
                CoLocationConstraint constraint = coLocationGroup.getLocationConstraint(executionVertexId.getSubtaskIndex());
                return this.constraintToExecutionSlotSharingGroupMap.get(constraint);
            }
            return null;
        }

        private ExecutionSlotSharingGroup tryFindAvailableProducerExecutionSlotSharingGroupFor(SchedulingExecutionVertex executionVertex) {
            ExecutionVertexID executionVertexId = (ExecutionVertexID)executionVertex.getId();
            for (SchedulingResultPartition partition : executionVertex.getConsumedResults()) {
                ExecutionVertexID producerVertexId = (ExecutionVertexID)((SchedulingExecutionVertex)partition.getProducer()).getId();
                if (!this.inSameLogicalSlotSharingGroup(producerVertexId, executionVertexId)) continue;
                ExecutionSlotSharingGroup producerGroup = this.executionSlotSharingGroupMap.get(producerVertexId);
                Preconditions.checkState((producerGroup != null ? 1 : 0) != 0);
                if (!this.isGroupAvailableForVertex(producerGroup, executionVertexId)) continue;
                return producerGroup;
            }
            return null;
        }

        private boolean inSameLogicalSlotSharingGroup(ExecutionVertexID executionVertexId1, ExecutionVertexID executionVertexId2) {
            return Objects.equals((Object)this.getSlotSharingGroup(executionVertexId1).getSlotSharingGroupId(), (Object)this.getSlotSharingGroup(executionVertexId2).getSlotSharingGroupId());
        }

        private SlotSharingGroup getSlotSharingGroup(ExecutionVertexID executionVertexId) {
            return (SlotSharingGroup)Preconditions.checkNotNull((Object)this.slotSharingGroupMap.get(executionVertexId.getJobVertexId()));
        }

        private boolean isGroupAvailableForVertex(ExecutionSlotSharingGroup executionSlotSharingGroup, ExecutionVertexID executionVertexId) {
            Set<JobVertexID> assignedVertices = this.assignedJobVerticesForGroups.get(executionSlotSharingGroup);
            return assignedVertices == null || !assignedVertices.contains(executionVertexId.getJobVertexId());
        }

        private void addVertexToExecutionSlotSharingGroup(SchedulingExecutionVertex vertex, ExecutionSlotSharingGroup group) {
            group.addVertex((ExecutionVertexID)vertex.getId());
            this.executionSlotSharingGroupMap.put((ExecutionVertexID)vertex.getId(), group);
            this.assignedJobVerticesForGroups.computeIfAbsent(group, k -> new HashSet()).add(((ExecutionVertexID)vertex.getId()).getJobVertexId());
        }

        private void findAvailableOrCreateNewExecutionSlotSharingGroupFor(List<SchedulingExecutionVertex> executionVertices) {
            for (SchedulingExecutionVertex executionVertex : executionVertices) {
                SlotSharingGroup slotSharingGroup = this.getSlotSharingGroup((ExecutionVertexID)executionVertex.getId());
                List groups = this.executionSlotSharingGroups.computeIfAbsent(slotSharingGroup.getSlotSharingGroupId(), k -> new ArrayList());
                ExecutionSlotSharingGroup group = null;
                for (ExecutionSlotSharingGroup executionSlotSharingGroup : groups) {
                    if (!this.isGroupAvailableForVertex(executionSlotSharingGroup, (ExecutionVertexID)executionVertex.getId())) continue;
                    group = executionSlotSharingGroup;
                    break;
                }
                if (group == null) {
                    group = new ExecutionSlotSharingGroup();
                    group.setResourceProfile(slotSharingGroup.getResourceProfile());
                    groups.add(group);
                }
                this.addVertexToExecutionSlotSharingGroup(executionVertex, group);
            }
        }

        private void updateConstraintToExecutionSlotSharingGroupMap(List<SchedulingExecutionVertex> executionVertices) {
            for (SchedulingExecutionVertex executionVertex : executionVertices) {
                ExecutionVertexID executionVertexId = (ExecutionVertexID)executionVertex.getId();
                CoLocationGroup coLocationGroup = this.coLocationGroupMap.get(executionVertexId.getJobVertexId());
                if (coLocationGroup == null) continue;
                CoLocationConstraint constraint = coLocationGroup.getLocationConstraint(executionVertexId.getSubtaskIndex());
                this.constraintToExecutionSlotSharingGroupMap.put(constraint, this.executionSlotSharingGroupMap.get(executionVertexId));
            }
        }
    }

    static class Factory
    implements SlotSharingStrategy.Factory {
        Factory() {
        }

        @Override
        public LocalInputPreferredSlotSharingStrategy create(SchedulingTopology topology, Set<SlotSharingGroup> logicalSlotSharingGroups, Set<CoLocationGroup> coLocationGroups) {
            return new LocalInputPreferredSlotSharingStrategy(topology, logicalSlotSharingGroups, coLocationGroups);
        }
    }
}

