/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.event.RuntimeEvent;

public class EventAnnouncement
extends RuntimeEvent {
    private final AbstractEvent announcedEvent;
    private final int sequenceNumber;

    public EventAnnouncement(AbstractEvent announcedEvent, int sequenceNumber) {
        this.announcedEvent = announcedEvent;
        this.sequenceNumber = sequenceNumber;
    }

    public AbstractEvent getAnnouncedEvent() {
        return this.announcedEvent;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void write(DataOutputView out) throws IOException {
        throw new UnsupportedOperationException("This method should never be called");
    }

    public void read(DataInputView in) throws IOException {
        throw new UnsupportedOperationException("This method should never be called");
    }

    public int hashCode() {
        return Objects.hash(this.announcedEvent, this.sequenceNumber);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != EventAnnouncement.class) {
            return false;
        }
        EventAnnouncement that = (EventAnnouncement)other;
        return Objects.equals(this.announcedEvent, that.announcedEvent) && this.sequenceNumber == that.sequenceNumber;
    }

    public String toString() {
        return String.format("Announcement of [%s] at %d", this.announcedEvent, this.sequenceNumber);
    }
}

