/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint;

import java.io.File;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.entrypoint.parser.CommandLineParser;
import org.apache.flink.runtime.entrypoint.parser.ParserResultFactory;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClusterEntrypointUtils {
    protected static final Logger LOG = LoggerFactory.getLogger(ClusterEntrypointUtils.class);

    private ClusterEntrypointUtils() {
        throw new UnsupportedOperationException("This class should not be instantiated.");
    }

    public static <T> T parseParametersOrExit(String[] args, ParserResultFactory<T> parserResultFactory, Class<?> mainClass) {
        CommandLineParser<T> commandLineParser = new CommandLineParser<T>(parserResultFactory);
        try {
            return commandLineParser.parse(args);
        }
        catch (Exception e) {
            LOG.error("Could not parse command line arguments {}.", (Object)args, (Object)e);
            commandLineParser.printHelp(mainClass.getSimpleName());
            System.exit(1);
            return null;
        }
    }

    public static Optional<File> tryFindUserLibDirectory() {
        File flinkHomeDirectory = ClusterEntrypointUtils.deriveFlinkHomeDirectoryFromLibDirectory();
        File usrLibDirectory = new File(flinkHomeDirectory, "usrlib");
        if (!usrLibDirectory.isDirectory()) {
            return Optional.empty();
        }
        return Optional.of(usrLibDirectory);
    }

    @Nullable
    private static File deriveFlinkHomeDirectoryFromLibDirectory() {
        String libDirectory = System.getenv().get("FLINK_LIB_DIR");
        if (libDirectory == null) {
            return null;
        }
        return new File(libDirectory).getParentFile();
    }

    public static int getPoolSize(Configuration config) {
        int poolSize = config.getInteger(ClusterOptions.CLUSTER_IO_EXECUTOR_POOL_SIZE, 4 * Hardware.getNumberCPUCores());
        Preconditions.checkArgument((poolSize > 0 ? 1 : 0) != 0, (Object)String.format("Illegal pool size (%s) of io-executor, please re-configure '%s'.", poolSize, ClusterOptions.CLUSTER_IO_EXECUTOR_POOL_SIZE.key()));
        return poolSize;
    }
}

