/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.concurrent;

import java.util.Objects;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;

public class ScheduledFutureAdapter<V>
implements ScheduledFuture<V> {
    private static final AtomicLong SEQUENCE_GEN = new AtomicLong();
    @Nonnull
    private final Future<V> delegate;
    private final long tieBreakerUid;
    private final long scheduleTimeNanos;

    public ScheduledFutureAdapter(@Nonnull Future<V> delegate2, long delay, @Nonnull TimeUnit timeUnit) {
        this(delegate2, System.nanoTime() + TimeUnit.NANOSECONDS.convert(delay, timeUnit), SEQUENCE_GEN.incrementAndGet());
    }

    @VisibleForTesting
    ScheduledFutureAdapter(@Nonnull Future<V> delegate2, long scheduleTimeNanos, long tieBreakerUid) {
        this.delegate = delegate2;
        this.scheduleTimeNanos = scheduleTimeNanos;
        this.tieBreakerUid = tieBreakerUid;
    }

    @Override
    public long getDelay(@Nonnull TimeUnit unit) {
        return unit.convert(this.scheduleTimeNanos - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(@Nonnull Delayed o) {
        if (o == this) {
            return 0;
        }
        if (o instanceof ScheduledFutureAdapter) {
            ScheduledFutureAdapter typedOther = (ScheduledFutureAdapter)o;
            int cmp = Long.compare(this.scheduleTimeNanos, typedOther.scheduleTimeNanos);
            return cmp != 0 ? cmp : Long.compare(this.tieBreakerUid, typedOther.tieBreakerUid);
        }
        return Long.compare(this.getDelay(TimeUnit.NANOSECONDS), o.getDelay(TimeUnit.NANOSECONDS));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.delegate.get();
    }

    @Override
    public V get(long timeout, @Nonnull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.get(timeout, unit);
    }

    @VisibleForTesting
    long getTieBreakerUid() {
        return this.tieBreakerUid;
    }

    @VisibleForTesting
    long getScheduleTimeNanos() {
        return this.scheduleTimeNanos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduledFutureAdapter that = (ScheduledFutureAdapter)o;
        return this.tieBreakerUid == that.tieBreakerUid && this.scheduleTimeNanos == that.scheduleTimeNanos;
    }

    public int hashCode() {
        return Objects.hash(this.tieBreakerUid, this.scheduleTimeNanos);
    }
}

