/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.flink.runtime.concurrent.DirectExecutorService;
import scala.concurrent.ExecutionContext;

public class Executors {
    public static Executor directExecutor() {
        return DirectExecutorService.INSTANCE;
    }

    public static ExecutorService newDirectExecutorService() {
        return new DirectExecutorService();
    }

    public static ExecutionContext directExecutionContext() {
        return DirectExecutionContext.INSTANCE;
    }

    private static class DirectExecutionContext
    implements ExecutionContext {
        static final DirectExecutionContext INSTANCE = new DirectExecutionContext();

        private DirectExecutionContext() {
        }

        public void execute(Runnable runnable) {
            runnable.run();
        }

        public void reportFailure(Throwable cause) {
            throw new IllegalStateException("Error in direct execution context.", cause);
        }

        public ExecutionContext prepare() {
            return this;
        }
    }
}

