/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;

public class PerJobCheckpointRecoveryFactory
implements CheckpointRecoveryFactory {
    private final Function<Integer, CompletedCheckpointStore> completedCheckpointStorePerJobFactory;
    private final Supplier<CheckpointIDCounter> checkpointIDCounterPerJobFactory;
    private final Map<JobID, CompletedCheckpointStore> store;
    private final Map<JobID, CheckpointIDCounter> counter;

    public PerJobCheckpointRecoveryFactory(Function<Integer, CompletedCheckpointStore> completedCheckpointStorePerJobFactory, Supplier<CheckpointIDCounter> checkpointIDCounterPerJobFactory) {
        this.completedCheckpointStorePerJobFactory = completedCheckpointStorePerJobFactory;
        this.checkpointIDCounterPerJobFactory = checkpointIDCounterPerJobFactory;
        this.store = new HashMap<JobID, CompletedCheckpointStore>();
        this.counter = new HashMap<JobID, CheckpointIDCounter>();
    }

    @Override
    public CompletedCheckpointStore createCheckpointStore(JobID jobId, int maxNumberOfCheckpointsToRetain, ClassLoader userClassLoader) {
        return this.store.computeIfAbsent(jobId, jId -> this.completedCheckpointStorePerJobFactory.apply(maxNumberOfCheckpointsToRetain));
    }

    @Override
    public CheckpointIDCounter createCheckpointIDCounter(JobID jobId) {
        return this.counter.computeIfAbsent(jobId, jId -> this.checkpointIDCounterPerJobFactory.get());
    }

    @VisibleForTesting
    public static CheckpointRecoveryFactory useSameServicesForAllJobs(CompletedCheckpointStore store, CheckpointIDCounter counter) {
        return new PerJobCheckpointRecoveryFactory(n -> store, () -> counter);
    }
}

