/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayList;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.InflightDataRescalingDescriptor;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.state.AbstractChannelStateHandle;
import org.apache.flink.runtime.state.CompositeStateHandle;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorSubtaskState
implements CompositeStateHandle {
    private static final Logger LOG = LoggerFactory.getLogger(OperatorSubtaskState.class);
    private static final long serialVersionUID = -2394696997971923995L;
    private final StateObjectCollection<OperatorStateHandle> managedOperatorState;
    private final StateObjectCollection<OperatorStateHandle> rawOperatorState;
    private final StateObjectCollection<KeyedStateHandle> managedKeyedState;
    private final StateObjectCollection<KeyedStateHandle> rawKeyedState;
    private final StateObjectCollection<InputChannelStateHandle> inputChannelState;
    private final StateObjectCollection<ResultSubpartitionStateHandle> resultSubpartitionState;
    private final InflightDataRescalingDescriptor inputRescalingDescriptor;
    private final InflightDataRescalingDescriptor outputRescalingDescriptor;
    private final long stateSize;

    private OperatorSubtaskState(StateObjectCollection<OperatorStateHandle> managedOperatorState, StateObjectCollection<OperatorStateHandle> rawOperatorState, StateObjectCollection<KeyedStateHandle> managedKeyedState, StateObjectCollection<KeyedStateHandle> rawKeyedState, StateObjectCollection<InputChannelStateHandle> inputChannelState, StateObjectCollection<ResultSubpartitionStateHandle> resultSubpartitionState, InflightDataRescalingDescriptor inputRescalingDescriptor, InflightDataRescalingDescriptor outputRescalingDescriptor) {
        this.managedOperatorState = (StateObjectCollection)Preconditions.checkNotNull(managedOperatorState);
        this.rawOperatorState = (StateObjectCollection)Preconditions.checkNotNull(rawOperatorState);
        this.managedKeyedState = (StateObjectCollection)Preconditions.checkNotNull(managedKeyedState);
        this.rawKeyedState = (StateObjectCollection)Preconditions.checkNotNull(rawKeyedState);
        this.inputChannelState = (StateObjectCollection)Preconditions.checkNotNull(inputChannelState);
        this.resultSubpartitionState = (StateObjectCollection)Preconditions.checkNotNull(resultSubpartitionState);
        this.inputRescalingDescriptor = (InflightDataRescalingDescriptor)Preconditions.checkNotNull((Object)inputRescalingDescriptor);
        this.outputRescalingDescriptor = (InflightDataRescalingDescriptor)Preconditions.checkNotNull((Object)outputRescalingDescriptor);
        long calculateStateSize = managedOperatorState.getStateSize();
        calculateStateSize += rawOperatorState.getStateSize();
        calculateStateSize += managedKeyedState.getStateSize();
        calculateStateSize += rawKeyedState.getStateSize();
        calculateStateSize += inputChannelState.getStateSize();
        this.stateSize = calculateStateSize += resultSubpartitionState.getStateSize();
    }

    @VisibleForTesting
    OperatorSubtaskState() {
        this(StateObjectCollection.empty(), StateObjectCollection.empty(), StateObjectCollection.empty(), StateObjectCollection.empty(), StateObjectCollection.empty(), StateObjectCollection.empty(), InflightDataRescalingDescriptor.NO_RESCALE, InflightDataRescalingDescriptor.NO_RESCALE);
    }

    public StateObjectCollection<OperatorStateHandle> getManagedOperatorState() {
        return this.managedOperatorState;
    }

    public StateObjectCollection<OperatorStateHandle> getRawOperatorState() {
        return this.rawOperatorState;
    }

    public StateObjectCollection<KeyedStateHandle> getManagedKeyedState() {
        return this.managedKeyedState;
    }

    public StateObjectCollection<KeyedStateHandle> getRawKeyedState() {
        return this.rawKeyedState;
    }

    public StateObjectCollection<InputChannelStateHandle> getInputChannelState() {
        return this.inputChannelState;
    }

    public StateObjectCollection<ResultSubpartitionStateHandle> getResultSubpartitionState() {
        return this.resultSubpartitionState;
    }

    public InflightDataRescalingDescriptor getInputRescalingDescriptor() {
        return this.inputRescalingDescriptor;
    }

    public InflightDataRescalingDescriptor getOutputRescalingDescriptor() {
        return this.outputRescalingDescriptor;
    }

    @Override
    public void discardState() {
        try {
            ArrayList<StateObject> toDispose = new ArrayList<StateObject>(this.managedOperatorState.size() + this.rawOperatorState.size() + this.managedKeyedState.size() + this.rawKeyedState.size() + this.inputChannelState.size() + this.resultSubpartitionState.size());
            toDispose.addAll(this.managedOperatorState);
            toDispose.addAll(this.rawOperatorState);
            toDispose.addAll(this.managedKeyedState);
            toDispose.addAll(this.rawKeyedState);
            toDispose.addAll(AbstractChannelStateHandle.collectUniqueDelegates(this.inputChannelState, this.resultSubpartitionState));
            StateUtil.bestEffortDiscardAllStateObjects(toDispose);
        }
        catch (Exception e) {
            LOG.warn("Error while discarding operator states.", (Throwable)e);
        }
    }

    @Override
    public void registerSharedStates(SharedStateRegistry sharedStateRegistry) {
        OperatorSubtaskState.registerSharedState(sharedStateRegistry, this.managedKeyedState);
        OperatorSubtaskState.registerSharedState(sharedStateRegistry, this.rawKeyedState);
    }

    private static void registerSharedState(SharedStateRegistry sharedStateRegistry, Iterable<KeyedStateHandle> stateHandles) {
        for (KeyedStateHandle stateHandle : stateHandles) {
            if (stateHandle == null) continue;
            stateHandle.registerSharedStates(sharedStateRegistry);
        }
    }

    @Override
    public long getStateSize() {
        return this.stateSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorSubtaskState that = (OperatorSubtaskState)o;
        if (this.getStateSize() != that.getStateSize()) {
            return false;
        }
        if (!this.getManagedOperatorState().equals(that.getManagedOperatorState())) {
            return false;
        }
        if (!this.getRawOperatorState().equals(that.getRawOperatorState())) {
            return false;
        }
        if (!this.getManagedKeyedState().equals(that.getManagedKeyedState())) {
            return false;
        }
        if (!this.getInputChannelState().equals(that.getInputChannelState())) {
            return false;
        }
        if (!this.getResultSubpartitionState().equals(that.getResultSubpartitionState())) {
            return false;
        }
        if (!this.getInputRescalingDescriptor().equals(that.getInputRescalingDescriptor())) {
            return false;
        }
        if (!this.getOutputRescalingDescriptor().equals(that.getOutputRescalingDescriptor())) {
            return false;
        }
        return this.getRawKeyedState().equals(that.getRawKeyedState());
    }

    public int hashCode() {
        int result = this.getManagedOperatorState().hashCode();
        result = 31 * result + this.getRawOperatorState().hashCode();
        result = 31 * result + this.getManagedKeyedState().hashCode();
        result = 31 * result + this.getRawKeyedState().hashCode();
        result = 31 * result + this.getInputChannelState().hashCode();
        result = 31 * result + this.getResultSubpartitionState().hashCode();
        result = 31 * result + this.getInputRescalingDescriptor().hashCode();
        result = 31 * result + this.getOutputRescalingDescriptor().hashCode();
        result = 31 * result + (int)(this.getStateSize() ^ this.getStateSize() >>> 32);
        return result;
    }

    public String toString() {
        return "SubtaskState{operatorStateFromBackend=" + this.managedOperatorState + ", operatorStateFromStream=" + this.rawOperatorState + ", keyedStateFromBackend=" + this.managedKeyedState + ", keyedStateFromStream=" + this.rawKeyedState + ", inputChannelState=" + this.inputChannelState + ", resultSubpartitionState=" + this.resultSubpartitionState + ", stateSize=" + this.stateSize + '}';
    }

    public boolean hasState() {
        return this.managedOperatorState.hasState() || this.rawOperatorState.hasState() || this.managedKeyedState.hasState() || this.rawKeyedState.hasState() || this.inputChannelState.hasState() || this.resultSubpartitionState.hasState();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private StateObjectCollection<OperatorStateHandle> managedOperatorState = StateObjectCollection.empty();
        private StateObjectCollection<OperatorStateHandle> rawOperatorState = StateObjectCollection.empty();
        private StateObjectCollection<KeyedStateHandle> managedKeyedState = StateObjectCollection.empty();
        private StateObjectCollection<KeyedStateHandle> rawKeyedState = StateObjectCollection.empty();
        private StateObjectCollection<InputChannelStateHandle> inputChannelState = StateObjectCollection.empty();
        private StateObjectCollection<ResultSubpartitionStateHandle> resultSubpartitionState = StateObjectCollection.empty();
        private InflightDataRescalingDescriptor inputRescalingDescriptor = InflightDataRescalingDescriptor.NO_RESCALE;
        private InflightDataRescalingDescriptor outputRescalingDescriptor = InflightDataRescalingDescriptor.NO_RESCALE;

        private Builder() {
        }

        public Builder setManagedOperatorState(StateObjectCollection<OperatorStateHandle> managedOperatorState) {
            this.managedOperatorState = (StateObjectCollection)Preconditions.checkNotNull(managedOperatorState);
            return this;
        }

        public Builder setManagedOperatorState(OperatorStateHandle managedOperatorState) {
            return this.setManagedOperatorState(StateObjectCollection.singleton((StateObject)Preconditions.checkNotNull((Object)managedOperatorState)));
        }

        public Builder setRawOperatorState(StateObjectCollection<OperatorStateHandle> rawOperatorState) {
            this.rawOperatorState = (StateObjectCollection)Preconditions.checkNotNull(rawOperatorState);
            return this;
        }

        public Builder setRawOperatorState(OperatorStateHandle rawOperatorState) {
            return this.setRawOperatorState(StateObjectCollection.singleton((StateObject)Preconditions.checkNotNull((Object)rawOperatorState)));
        }

        public Builder setManagedKeyedState(StateObjectCollection<KeyedStateHandle> managedKeyedState) {
            this.managedKeyedState = (StateObjectCollection)Preconditions.checkNotNull(managedKeyedState);
            return this;
        }

        public Builder setManagedKeyedState(KeyedStateHandle managedKeyedState) {
            return this.setManagedKeyedState(StateObjectCollection.singleton((StateObject)Preconditions.checkNotNull((Object)managedKeyedState)));
        }

        public Builder setRawKeyedState(StateObjectCollection<KeyedStateHandle> rawKeyedState) {
            this.rawKeyedState = (StateObjectCollection)Preconditions.checkNotNull(rawKeyedState);
            return this;
        }

        public Builder setRawKeyedState(KeyedStateHandle rawKeyedState) {
            return this.setRawKeyedState(StateObjectCollection.singleton((StateObject)Preconditions.checkNotNull((Object)rawKeyedState)));
        }

        public Builder setInputChannelState(StateObjectCollection<InputChannelStateHandle> inputChannelState) {
            this.inputChannelState = (StateObjectCollection)Preconditions.checkNotNull(inputChannelState);
            return this;
        }

        public Builder setResultSubpartitionState(StateObjectCollection<ResultSubpartitionStateHandle> resultSubpartitionState) {
            this.resultSubpartitionState = (StateObjectCollection)Preconditions.checkNotNull(resultSubpartitionState);
            return this;
        }

        public Builder setInputRescalingDescriptor(InflightDataRescalingDescriptor inputRescalingDescriptor) {
            this.inputRescalingDescriptor = (InflightDataRescalingDescriptor)Preconditions.checkNotNull((Object)inputRescalingDescriptor);
            return this;
        }

        public Builder setOutputRescalingDescriptor(InflightDataRescalingDescriptor outputRescalingDescriptor) {
            this.outputRescalingDescriptor = (InflightDataRescalingDescriptor)Preconditions.checkNotNull((Object)outputRescalingDescriptor);
            return this;
        }

        public OperatorSubtaskState build() {
            return new OperatorSubtaskState(this.managedOperatorState, this.rawOperatorState, this.managedKeyedState, this.rawKeyedState, this.inputChannelState, this.resultSubpartitionState, this.inputRescalingDescriptor, this.outputRescalingDescriptor);
        }
    }
}

