/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.taskexecutor.SlotReport;
import org.apache.flink.runtime.taskexecutor.slot.SlotActions;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlot;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotPayload;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTable;

public class TestingTaskSlotTable<T extends TaskSlotPayload>
implements TaskSlotTable<T> {
    private final Supplier<SlotReport> createSlotReportSupplier;
    private final Supplier<Boolean> allocateSlotSupplier;
    private final BiFunction<JobID, AllocationID, Boolean> tryMarkSlotActiveBiFunction;
    private final Function<T, Boolean> addTaskFunction;
    private final Function<AllocationID, MemoryManager> memoryManagerGetter;
    private final Supplier<CompletableFuture<Void>> closeAsyncSupplier;
    private final Function<JobID, Iterator<T>> tasksForJobFunction;
    private final Supplier<Set<AllocationID>> allActiveSlotAllocationIdsSupplier;
    private final Function<JobID, Set<AllocationID>> activeSlotAllocationIdsForJobFunction;

    private TestingTaskSlotTable(Supplier<SlotReport> createSlotReportSupplier, Supplier<Boolean> allocateSlotSupplier, BiFunction<JobID, AllocationID, Boolean> tryMarkSlotActiveBiFunction, Function<T, Boolean> addTaskFunction, Function<AllocationID, MemoryManager> memoryManagerGetter, Supplier<CompletableFuture<Void>> closeAsyncSupplier, Function<JobID, Iterator<T>> tasksForJobFunction, Supplier<Set<AllocationID>> allActiveSlotAllocationIdsSupplier, Function<JobID, Set<AllocationID>> activeSlotAllocationIdsForJobFunction) {
        this.createSlotReportSupplier = createSlotReportSupplier;
        this.allocateSlotSupplier = allocateSlotSupplier;
        this.tryMarkSlotActiveBiFunction = tryMarkSlotActiveBiFunction;
        this.addTaskFunction = addTaskFunction;
        this.memoryManagerGetter = memoryManagerGetter;
        this.closeAsyncSupplier = closeAsyncSupplier;
        this.tasksForJobFunction = tasksForJobFunction;
        this.allActiveSlotAllocationIdsSupplier = allActiveSlotAllocationIdsSupplier;
        this.activeSlotAllocationIdsForJobFunction = activeSlotAllocationIdsForJobFunction;
    }

    public void start(SlotActions initialSlotActions, ComponentMainThreadExecutor mainThreadExecutor) {
    }

    public Set<AllocationID> getAllocationIdsPerJob(JobID jobId) {
        throw new UnsupportedOperationException();
    }

    public Set<AllocationID> getActiveTaskSlotAllocationIds() {
        return this.allActiveSlotAllocationIdsSupplier.get();
    }

    public Set<AllocationID> getActiveTaskSlotAllocationIdsPerJob(JobID jobId) {
        return this.activeSlotAllocationIdsForJobFunction.apply(jobId);
    }

    public SlotReport createSlotReport(ResourceID resourceId) {
        return this.createSlotReportSupplier.get();
    }

    public boolean allocateSlot(int index, JobID jobId, AllocationID allocationId, Time slotTimeout) {
        return this.allocateSlotSupplier.get();
    }

    public boolean allocateSlot(int index, JobID jobId, AllocationID allocationId, ResourceProfile resourceProfile, Time slotTimeout) {
        return this.allocateSlotSupplier.get();
    }

    public boolean markSlotActive(AllocationID allocationId) {
        throw new UnsupportedOperationException();
    }

    public boolean markSlotInactive(AllocationID allocationId, Time slotTimeout) {
        throw new UnsupportedOperationException();
    }

    public int freeSlot(AllocationID allocationId, Throwable cause) {
        throw new UnsupportedOperationException();
    }

    public boolean isValidTimeout(AllocationID allocationId, UUID ticket) {
        throw new UnsupportedOperationException();
    }

    public boolean isAllocated(int index, JobID jobId, AllocationID allocationId) {
        throw new UnsupportedOperationException();
    }

    public boolean tryMarkSlotActive(JobID jobId, AllocationID allocationId) {
        return this.tryMarkSlotActiveBiFunction.apply(jobId, allocationId);
    }

    public boolean isSlotFree(int index) {
        throw new UnsupportedOperationException();
    }

    public boolean hasAllocatedSlots(JobID jobId) {
        throw new UnsupportedOperationException();
    }

    public Iterator<TaskSlot<T>> getAllocatedSlots(JobID jobId) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public JobID getOwningJob(AllocationID allocationId) {
        throw new UnsupportedOperationException();
    }

    public boolean addTask(T task) {
        return this.addTaskFunction.apply(task);
    }

    public T removeTask(ExecutionAttemptID executionAttemptID) {
        throw new UnsupportedOperationException();
    }

    public T getTask(ExecutionAttemptID executionAttemptID) {
        throw new UnsupportedOperationException();
    }

    public Iterator<T> getTasks(JobID jobId) {
        return this.tasksForJobFunction.apply(jobId);
    }

    public AllocationID getCurrentAllocation(int index) {
        throw new UnsupportedOperationException();
    }

    public MemoryManager getTaskMemoryManager(AllocationID allocationID) {
        return this.memoryManagerGetter.apply(allocationID);
    }

    public void notifyTimeout(AllocationID key, UUID ticket) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Void> closeAsync() {
        return this.closeAsyncSupplier.get();
    }

    public static <T extends TaskSlotPayload> TestingTaskSlotTableBuilder<T> newBuilder() {
        return new TestingTaskSlotTableBuilder();
    }

    public static class TestingTaskSlotTableBuilder<T extends TaskSlotPayload> {
        private Supplier<SlotReport> createSlotReportSupplier = SlotReport::new;
        private Supplier<Boolean> allocateSlotSupplier = () -> false;
        private BiFunction<JobID, AllocationID, Boolean> tryMarkSlotActiveBiFunction = (ignoredA, ignoredB) -> false;
        private Function<T, Boolean> addTaskFunction = ignored -> false;
        private Function<AllocationID, MemoryManager> memoryManagerGetter = ignored -> {
            throw new UnsupportedOperationException("No memory manager getter has been set.");
        };
        private Supplier<CompletableFuture<Void>> closeAsyncSupplier = FutureUtils::completedVoidFuture;
        private Function<JobID, Iterator<T>> tasksForJobFunction = ignored -> Collections.emptyIterator();
        private Supplier<Set<AllocationID>> allActiveSlotAllocationIdsSupplier = Collections::emptySet;
        private Function<JobID, Set<AllocationID>> activeSlotAllocationIdsForJobFunction = ignored -> Collections.emptySet();

        public TestingTaskSlotTableBuilder<T> createSlotReportSupplier(Supplier<SlotReport> createSlotReportSupplier) {
            this.createSlotReportSupplier = createSlotReportSupplier;
            return this;
        }

        public TestingTaskSlotTableBuilder<T> allocateSlotReturns(boolean toReturn) {
            this.allocateSlotSupplier = () -> toReturn;
            return this;
        }

        public TestingTaskSlotTableBuilder<T> tryMarkSlotActiveReturns(boolean toReturn) {
            this.tryMarkSlotActiveBiFunction = (stub1, stub2) -> toReturn;
            return this;
        }

        public TestingTaskSlotTableBuilder<T> addTaskReturns(boolean toReturn) {
            this.addTaskFunction = stub -> toReturn;
            return this;
        }

        public TestingTaskSlotTableBuilder<T> memoryManagerGetterReturns(MemoryManager toReturn) {
            this.memoryManagerGetter = stub -> toReturn;
            return this;
        }

        public TestingTaskSlotTableBuilder<T> closeAsyncReturns(CompletableFuture<Void> toReturn) {
            this.closeAsyncSupplier = () -> toReturn;
            return this;
        }

        public TestingTaskSlotTableBuilder<T> tasksForJobReturns(Function<JobID, Iterator<T>> tasksForJobFunction) {
            this.tasksForJobFunction = tasksForJobFunction;
            return this;
        }

        public TestingTaskSlotTableBuilder<T> allActiveSlotAllocationIds(Supplier<Set<AllocationID>> allActiveSlotAllocationIdsSupplier) {
            this.allActiveSlotAllocationIdsSupplier = allActiveSlotAllocationIdsSupplier;
            return this;
        }

        public TestingTaskSlotTableBuilder<T> activeSlotAllocationIdsForJobReturns(Function<JobID, Set<AllocationID>> activeSlotAllocationIdsForJobFunction) {
            this.activeSlotAllocationIdsForJobFunction = activeSlotAllocationIdsForJobFunction;
            return this;
        }

        public TaskSlotTable<T> build() {
            return new TestingTaskSlotTable(this.createSlotReportSupplier, this.allocateSlotSupplier, this.tryMarkSlotActiveBiFunction, this.addTaskFunction, this.memoryManagerGetter, this.closeAsyncSupplier, this.tasksForJobFunction, this.allActiveSlotAllocationIdsSupplier, this.activeSlotAllocationIdsForJobFunction);
        }
    }
}

