/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.runtime.state.StateSnapshotTransformer;
import org.apache.flink.runtime.state.heap.NestedStateMap;
import org.apache.flink.runtime.state.heap.StateMapSnapshot;
import org.apache.flink.runtime.state.testutils.StateEntryMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class NestedMapsStateTableTest {
    @Test
    public void testIteratingOverSnapshot() {
        ListSerializer stateSerializer = new ListSerializer((TypeSerializer)IntSerializer.INSTANCE);
        NestedStateMap stateMap = new NestedStateMap();
        ArrayList<Integer> originalState1 = new ArrayList<Integer>(1);
        ArrayList<Integer> originalState2 = new ArrayList<Integer>(1);
        ArrayList<Integer> originalState3 = new ArrayList<Integer>(1);
        ArrayList<Integer> originalState4 = new ArrayList<Integer>(1);
        ArrayList<Integer> originalState5 = new ArrayList<Integer>(1);
        originalState1.add(1);
        originalState2.add(2);
        originalState3.add(3);
        originalState4.add(4);
        originalState5.add(5);
        stateMap.put((Object)1, (Object)1, originalState1);
        stateMap.put((Object)2, (Object)1, originalState2);
        stateMap.put((Object)3, (Object)1, originalState3);
        stateMap.put((Object)4, (Object)1, originalState4);
        stateMap.put((Object)5, (Object)1, originalState5);
        StateMapSnapshot snapshot = stateMap.stateSnapshot();
        Iterator iterator = snapshot.getIterator((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)stateSerializer, null);
        Assert.assertThat(() -> iterator, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{StateEntryMatcher.entry(1, 1, originalState1), StateEntryMatcher.entry(2, 1, originalState2), StateEntryMatcher.entry(3, 1, originalState3), StateEntryMatcher.entry(4, 1, originalState4), StateEntryMatcher.entry(5, 1, originalState5)}));
    }

    @Test
    public void testIteratingOverSnapshotWithTransform() {
        NestedStateMap stateMap = new NestedStateMap();
        stateMap.put((Object)1, (Object)1, (Object)10L);
        stateMap.put((Object)2, (Object)1, (Object)11L);
        stateMap.put((Object)3, (Object)1, (Object)12L);
        stateMap.put((Object)4, (Object)1, (Object)13L);
        stateMap.put((Object)5, (Object)1, (Object)14L);
        StateMapSnapshot snapshot = stateMap.stateSnapshot();
        Iterator iterator = snapshot.getIterator((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)LongSerializer.INSTANCE, (StateSnapshotTransformer)new StateSnapshotTransformer<Long>(){

            @Nullable
            public Long filterOrTransform(@Nullable Long value) {
                if (value == 12L) {
                    return null;
                }
                return value + 2L;
            }
        });
        Assert.assertThat(() -> iterator, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{StateEntryMatcher.entry(1, 1, 12L), StateEntryMatcher.entry(2, 1, 13L), StateEntryMatcher.entry(4, 1, 15L), StateEntryMatcher.entry(5, 1, 16L)}));
    }
}

