/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.StateBackendTestBase;
import org.apache.flink.runtime.state.hashmap.HashMapStateBackend;
import org.apache.flink.runtime.state.storage.FileSystemCheckpointStorage;
import org.apache.flink.runtime.state.storage.JobManagerCheckpointStorage;
import org.apache.flink.util.function.SupplierWithException;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HashMapStateBackendTest
extends StateBackendTestBase<HashMapStateBackend> {
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();
    @Parameterized.Parameter
    public SupplierWithException<CheckpointStorage, IOException> storageSupplier;

    @Parameterized.Parameters
    public static List<Object[]> modes() {
        return Arrays.asList({JobManagerCheckpointStorage::new}, {() -> {
            String checkpointPath = TEMP_FOLDER.newFolder().toURI().toString();
            return new FileSystemCheckpointStorage(checkpointPath);
        }});
    }

    @Override
    protected HashMapStateBackend getStateBackend() {
        return new HashMapStateBackend();
    }

    @Override
    protected CheckpointStorage getCheckpointStorage() throws Exception {
        return (CheckpointStorage)this.storageSupplier.get();
    }

    @Override
    protected boolean supportsAsynchronousSnapshots() {
        return true;
    }

    @Override
    protected boolean isSerializerPresenceRequiredOnRestore() {
        return true;
    }

    @Override
    @Test
    public void testValueStateRestoreWithWrongSerializers() {
    }

    @Override
    @Test
    public void testListStateRestoreWithWrongSerializers() {
    }

    @Override
    @Test
    public void testReducingStateRestoreWithWrongSerializers() {
    }

    @Override
    @Test
    public void testMapStateRestoreWithWrongSerializers() {
    }

    @Override
    @Ignore
    @Test
    public void testConcurrentMapIfQueryable() throws Exception {
        super.testConcurrentMapIfQueryable();
    }
}

