/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingResultPartition;
import org.apache.flink.util.IterableUtils;
import org.apache.flink.util.Preconditions;

public class TestingSchedulingExecutionVertex
implements SchedulingExecutionVertex {
    private final ExecutionVertexID executionVertexId;
    private final List<ConsumedPartitionGroup> consumedPartitionGroups;
    private final Collection<TestingSchedulingResultPartition> producedPartitions;
    private final Map<IntermediateResultPartitionID, TestingSchedulingResultPartition> resultPartitionsById;
    private ExecutionState executionState;

    public TestingSchedulingExecutionVertex(JobVertexID jobVertexId, int subtaskIndex, List<ConsumedPartitionGroup> consumedPartitionGroups, Map<IntermediateResultPartitionID, TestingSchedulingResultPartition> resultPartitionsById, ExecutionState executionState) {
        this.executionVertexId = new ExecutionVertexID(jobVertexId, subtaskIndex);
        this.consumedPartitionGroups = (List)Preconditions.checkNotNull(consumedPartitionGroups);
        this.producedPartitions = new ArrayList<TestingSchedulingResultPartition>();
        this.resultPartitionsById = (Map)Preconditions.checkNotNull(resultPartitionsById);
        this.executionState = executionState;
    }

    public ExecutionVertexID getId() {
        return this.executionVertexId;
    }

    public ExecutionState getState() {
        return this.executionState;
    }

    public void setState(ExecutionState state) {
        this.executionState = state;
    }

    public Iterable<TestingSchedulingResultPartition> getConsumedResults() {
        return IterableUtils.flatMap(this.consumedPartitionGroups, this.resultPartitionsById::get);
    }

    public Iterable<TestingSchedulingResultPartition> getProducedResults() {
        return this.producedPartitions;
    }

    public List<ConsumedPartitionGroup> getConsumedPartitionGroups() {
        return this.consumedPartitionGroups;
    }

    void addConsumedPartition(TestingSchedulingResultPartition consumedPartition) {
        this.consumedPartitionGroups.add(ConsumedPartitionGroup.fromSinglePartition((IntermediateResultPartitionID)consumedPartition.getId()));
        this.resultPartitionsById.putIfAbsent(consumedPartition.getId(), consumedPartition);
    }

    void addConsumedPartitionGroup(ConsumedPartitionGroup consumedPartitionGroup, Map<IntermediateResultPartitionID, TestingSchedulingResultPartition> consumedResultPartitionById) {
        this.consumedPartitionGroups.add(consumedPartitionGroup);
        this.resultPartitionsById.putAll(consumedResultPartitionById);
    }

    void addProducedPartition(TestingSchedulingResultPartition partition) {
        this.producedPartitions.add(partition);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static TestingSchedulingExecutionVertex withExecutionVertexID(JobVertexID jobVertexId, int subtaskIndex) {
        return TestingSchedulingExecutionVertex.newBuilder().withExecutionVertexID(jobVertexId, subtaskIndex).build();
    }

    public static class Builder {
        private JobVertexID jobVertexId = new JobVertexID();
        private int subtaskIndex = 0;
        private final List<ConsumedPartitionGroup> consumedPartitionGroups = new ArrayList<ConsumedPartitionGroup>();
        private final Map<IntermediateResultPartitionID, TestingSchedulingResultPartition> resultPartitionsById = new HashMap<IntermediateResultPartitionID, TestingSchedulingResultPartition>();
        private ExecutionState executionState = ExecutionState.CREATED;

        Builder withExecutionVertexID(JobVertexID jobVertexId, int subtaskIndex) {
            this.jobVertexId = jobVertexId;
            this.subtaskIndex = subtaskIndex;
            return this;
        }

        public Builder withConsumedPartitionGroups(List<ConsumedPartitionGroup> consumedPartitionGroups, Map<IntermediateResultPartitionID, TestingSchedulingResultPartition> resultPartitionsById) {
            this.resultPartitionsById.putAll(resultPartitionsById);
            for (ConsumedPartitionGroup partitionGroup : consumedPartitionGroups) {
                ArrayList<IntermediateResultPartitionID> partitionIds = new ArrayList<IntermediateResultPartitionID>(partitionGroup.size());
                for (IntermediateResultPartitionID partitionId : partitionGroup) {
                    partitionIds.add(partitionId);
                }
                this.consumedPartitionGroups.add(ConsumedPartitionGroup.fromMultiplePartitions(partitionIds));
            }
            return this;
        }

        public Builder withExecutionState(ExecutionState executionState) {
            this.executionState = executionState;
            return this;
        }

        public TestingSchedulingExecutionVertex build() {
            return new TestingSchedulingExecutionVertex(this.jobVertexId, this.subtaskIndex, this.consumedPartitionGroups, this.resultPartitionsById, this.executionState);
        }
    }
}

