/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.benchmark.partitionrelease;

import java.util.List;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlotBuilder;
import org.apache.flink.runtime.scheduler.benchmark.JobConfiguration;
import org.apache.flink.runtime.scheduler.benchmark.SchedulerBenchmarkUtils;

public class PartitionReleaseInBatchJobBenchmark {
    private ExecutionGraph executionGraph;
    private JobVertex sink;

    public void setup(JobConfiguration jobConfiguration) throws Exception {
        List<JobVertex> jobVertices = SchedulerBenchmarkUtils.createDefaultJobVertices(jobConfiguration);
        this.executionGraph = SchedulerBenchmarkUtils.createAndInitExecutionGraph(jobVertices, jobConfiguration);
        JobVertex source = jobVertices.get(0);
        this.sink = jobVertices.get(1);
        TestingLogicalSlotBuilder slotBuilder = new TestingLogicalSlotBuilder();
        SchedulerBenchmarkUtils.deployTasks(this.executionGraph, source.getID(), slotBuilder, true);
        SchedulerBenchmarkUtils.transitionTaskStatus(this.executionGraph, source.getID(), ExecutionState.FINISHED);
        SchedulerBenchmarkUtils.deployTasks(this.executionGraph, this.sink.getID(), slotBuilder, true);
    }

    public void partitionRelease() {
        SchedulerBenchmarkUtils.transitionTaskStatus(this.executionGraph, this.sink.getID(), ExecutionState.FINISHED);
    }
}

