/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.blob.VoidBlobWriter;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.PendingCheckpoint;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.concurrent.ScheduledExecutorServiceAdapter;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailoverStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.NoRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.RestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.RestartPipelinedRegionFailoverStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.TestRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.io.network.partition.NoOpJobMasterPartitionTracker;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.jobgraph.tasks.JobCheckpointingSettings;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.DefaultExecutionDeploymentTracker;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentTracker;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProvider;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequestBulkChecker;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.checkpoint.AcknowledgeCheckpoint;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.scheduler.DefaultExecutionGraphFactory;
import org.apache.flink.runtime.scheduler.DefaultExecutionVertexOperations;
import org.apache.flink.runtime.scheduler.DefaultScheduler;
import org.apache.flink.runtime.scheduler.ExecutionGraphFactory;
import org.apache.flink.runtime.scheduler.ExecutionSlotAllocatorFactory;
import org.apache.flink.runtime.scheduler.ExecutionVertexOperations;
import org.apache.flink.runtime.scheduler.ExecutionVertexVersioner;
import org.apache.flink.runtime.scheduler.LocalInputPreferredSlotSharingStrategy;
import org.apache.flink.runtime.scheduler.SchedulerBase;
import org.apache.flink.runtime.scheduler.SlotSharingExecutionSlotAllocatorFactory;
import org.apache.flink.runtime.scheduler.SlotSharingStrategy;
import org.apache.flink.runtime.scheduler.TestExecutionSlotAllocatorFactory;
import org.apache.flink.runtime.scheduler.TestingPhysicalSlotProvider;
import org.apache.flink.runtime.scheduler.TestingPhysicalSlotRequestBulkChecker;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.PipelinedRegionSchedulingStrategy;
import org.apache.flink.runtime.scheduler.strategy.SchedulingStrategyFactory;
import org.apache.flink.runtime.shuffle.NettyShuffleMaster;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.taskexecutor.TaskExecutorOperatorEventGateway;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.SerializedValue;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerTestingUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerTestingUtils.class);
    private static final long DEFAULT_CHECKPOINT_TIMEOUT_MS = 600000L;
    private static final Time DEFAULT_TIMEOUT = Time.seconds((long)300L);

    private SchedulerTestingUtils() {
    }

    public static DefaultSchedulerBuilder newSchedulerBuilder(JobGraph jobGraph, ComponentMainThreadExecutor mainThreadExecutor) {
        return new DefaultSchedulerBuilder(jobGraph, mainThreadExecutor);
    }

    public static DefaultScheduler createScheduler(JobGraph jobGraph, ComponentMainThreadExecutor mainThreadExecutor) throws Exception {
        return SchedulerTestingUtils.newSchedulerBuilder(jobGraph, mainThreadExecutor).build();
    }

    public static DefaultSchedulerBuilder createSchedulerBuilder(JobGraph jobGraph, ComponentMainThreadExecutor mainThreadExecutor) {
        return SchedulerTestingUtils.createSchedulerBuilder(jobGraph, mainThreadExecutor, new SimpleAckingTaskManagerGateway());
    }

    public static DefaultSchedulerBuilder createSchedulerBuilder(JobGraph jobGraph, ComponentMainThreadExecutor mainThreadExecutor, TaskExecutorOperatorEventGateway operatorEventGateway) {
        TaskManagerGateway gateway = operatorEventGateway instanceof TaskManagerGateway ? (TaskManagerGateway)operatorEventGateway : new TaskExecutorOperatorEventGatewayAdapter(operatorEventGateway);
        return SchedulerTestingUtils.createSchedulerBuilder(jobGraph, mainThreadExecutor, gateway);
    }

    public static DefaultSchedulerBuilder createSchedulerBuilder(JobGraph jobGraph, ComponentMainThreadExecutor mainThreadExecutor, TaskManagerGateway taskManagerGateway) {
        return SchedulerTestingUtils.newSchedulerBuilder(jobGraph, mainThreadExecutor).setSchedulingStrategyFactory((SchedulingStrategyFactory)new PipelinedRegionSchedulingStrategy.Factory()).setRestartBackoffTimeStrategy(new TestRestartBackoffTimeStrategy(true, 0L)).setExecutionSlotAllocatorFactory(new TestExecutionSlotAllocatorFactory(taskManagerGateway));
    }

    public static void enableCheckpointing(JobGraph jobGraph) {
        SchedulerTestingUtils.enableCheckpointing(jobGraph, null, null);
    }

    public static void enableCheckpointing(JobGraph jobGraph, @Nullable StateBackend stateBackend, @Nullable CheckpointStorage checkpointStorage) {
        CheckpointCoordinatorConfiguration config = new CheckpointCoordinatorConfiguration(Long.MAX_VALUE, 600000L, 0L, 1, CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION, false, false, false, 0);
        SerializedValue serializedStateBackend = null;
        if (stateBackend != null) {
            try {
                serializedStateBackend = new SerializedValue((Object)stateBackend);
            }
            catch (IOException e) {
                throw new RuntimeException("could not serialize state backend", e);
            }
        }
        SerializedValue serializedCheckpointStorage = null;
        if (checkpointStorage != null) {
            try {
                serializedCheckpointStorage = new SerializedValue((Object)checkpointStorage);
            }
            catch (IOException e) {
                throw new RuntimeException("could not serialize checkpoint storage", e);
            }
        }
        jobGraph.setSnapshotSettings(new JobCheckpointingSettings(config, serializedStateBackend, serializedCheckpointStorage, null));
    }

    public static Collection<ExecutionAttemptID> getAllCurrentExecutionAttempts(DefaultScheduler scheduler) {
        return StreamSupport.stream(scheduler.requestJob().getArchivedExecutionGraph().getAllExecutionVertices().spliterator(), false).map(vertex -> vertex.getCurrentExecutionAttempt().getAttemptId()).collect(Collectors.toList());
    }

    public static ExecutionState getExecutionState(DefaultScheduler scheduler, JobVertexID jvid, int subtask) {
        ExecutionJobVertex ejv = SchedulerTestingUtils.getJobVertex(scheduler, jvid);
        return ejv.getTaskVertices()[subtask].getCurrentExecutionAttempt().getState();
    }

    public static void failExecution(DefaultScheduler scheduler, JobVertexID jvid, int subtask) {
        ExecutionAttemptID attemptID = SchedulerTestingUtils.getAttemptId(scheduler, jvid, subtask);
        scheduler.updateTaskExecutionState(new TaskExecutionState(attemptID, ExecutionState.FAILED, (Throwable)new Exception("test task failure")));
    }

    public static void canceledExecution(DefaultScheduler scheduler, JobVertexID jvid, int subtask) {
        ExecutionAttemptID attemptID = SchedulerTestingUtils.getAttemptId(scheduler, jvid, subtask);
        scheduler.updateTaskExecutionState(new TaskExecutionState(attemptID, ExecutionState.CANCELED, (Throwable)new Exception("test task failure")));
    }

    public static void setExecutionToState(ExecutionState executionState, DefaultScheduler scheduler, JobVertexID jvid, int subtask) {
        ExecutionAttemptID attemptID = SchedulerTestingUtils.getAttemptId(scheduler, jvid, subtask);
        scheduler.updateTaskExecutionState(new TaskExecutionState(attemptID, executionState));
    }

    public static void setAllExecutionsToRunning(DefaultScheduler scheduler) {
        SchedulerTestingUtils.getAllCurrentExecutionAttempts(scheduler).forEach(attemptId -> {
            scheduler.updateTaskExecutionState(new TaskExecutionState(attemptId, ExecutionState.INITIALIZING));
            scheduler.updateTaskExecutionState(new TaskExecutionState(attemptId, ExecutionState.RUNNING));
        });
    }

    public static void setAllExecutionsToCancelled(DefaultScheduler scheduler) {
        for (ExecutionAttemptID attemptId : SchedulerTestingUtils.getAllCurrentExecutionAttempts(scheduler)) {
            boolean setToRunning = scheduler.updateTaskExecutionState(new TaskExecutionState(attemptId, ExecutionState.CANCELED));
            Assert.assertTrue((String)"could not switch task to RUNNING", (boolean)setToRunning);
        }
    }

    public static void acknowledgePendingCheckpoint(DefaultScheduler scheduler, long checkpointId) throws CheckpointException {
        CheckpointCoordinator checkpointCoordinator = SchedulerTestingUtils.getCheckpointCoordinator((SchedulerBase)scheduler);
        JobID jid = scheduler.getJobId();
        for (ExecutionAttemptID attemptId : SchedulerTestingUtils.getAllCurrentExecutionAttempts(scheduler)) {
            AcknowledgeCheckpoint acknowledgeCheckpoint = new AcknowledgeCheckpoint(jid, attemptId, checkpointId);
            checkpointCoordinator.receiveAcknowledgeMessage(acknowledgeCheckpoint, "Unknown location");
        }
    }

    public static CompletableFuture<CompletedCheckpoint> triggerCheckpoint(DefaultScheduler scheduler) throws Exception {
        CheckpointCoordinator checkpointCoordinator = SchedulerTestingUtils.getCheckpointCoordinator((SchedulerBase)scheduler);
        return checkpointCoordinator.triggerCheckpoint(false);
    }

    public static void acknowledgeCurrentCheckpoint(DefaultScheduler scheduler) {
        CheckpointCoordinator checkpointCoordinator = SchedulerTestingUtils.getCheckpointCoordinator((SchedulerBase)scheduler);
        Assert.assertEquals((String)"Coordinator has not ", (long)1L, (long)checkpointCoordinator.getNumberOfPendingCheckpoints());
        PendingCheckpoint pc = (PendingCheckpoint)checkpointCoordinator.getPendingCheckpoints().values().iterator().next();
        while (pc.getNumberOfNonAcknowledgedOperatorCoordinators() > 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Assert.fail((String)"interrupted");
            }
        }
        SchedulerTestingUtils.getAllCurrentExecutionAttempts(scheduler).forEach(attemptId -> scheduler.acknowledgeCheckpoint(pc.getJobId(), attemptId, pc.getCheckpointId(), new CheckpointMetrics(), null));
    }

    public static CompletedCheckpoint takeCheckpoint(DefaultScheduler scheduler) throws Exception {
        CheckpointCoordinator checkpointCoordinator = SchedulerTestingUtils.getCheckpointCoordinator((SchedulerBase)scheduler);
        checkpointCoordinator.triggerCheckpoint(false);
        Assert.assertEquals((String)"test setup inconsistent", (long)1L, (long)checkpointCoordinator.getNumberOfPendingCheckpoints());
        PendingCheckpoint checkpoint = (PendingCheckpoint)checkpointCoordinator.getPendingCheckpoints().values().iterator().next();
        CompletableFuture future = checkpoint.getCompletionFuture();
        SchedulerTestingUtils.acknowledgePendingCheckpoint(scheduler, checkpoint.getCheckpointId());
        CompletedCheckpoint completed = future.getNow(null);
        Assert.assertNotNull((String)"checkpoint not complete", (Object)completed);
        return completed;
    }

    public static CheckpointCoordinator getCheckpointCoordinator(SchedulerBase scheduler) {
        return scheduler.getCheckpointCoordinator();
    }

    private static ExecutionJobVertex getJobVertex(DefaultScheduler scheduler, JobVertexID jobVertexId) {
        ExecutionVertexID id = new ExecutionVertexID(jobVertexId, 0);
        return scheduler.getExecutionVertex(id).getJobVertex();
    }

    public static ExecutionAttemptID getAttemptId(DefaultScheduler scheduler, JobVertexID jvid, int subtask) {
        ExecutionJobVertex ejv = SchedulerTestingUtils.getJobVertex(scheduler, jvid);
        assert (ejv != null);
        return ejv.getTaskVertices()[subtask].getCurrentExecutionAttempt().getAttemptId();
    }

    public static SlotSharingExecutionSlotAllocatorFactory newSlotSharingExecutionSlotAllocatorFactory() {
        return SchedulerTestingUtils.newSlotSharingExecutionSlotAllocatorFactory(TestingPhysicalSlotProvider.createWithInfiniteSlotCreation());
    }

    public static SlotSharingExecutionSlotAllocatorFactory newSlotSharingExecutionSlotAllocatorFactory(PhysicalSlotProvider physicalSlotProvider) {
        return SchedulerTestingUtils.newSlotSharingExecutionSlotAllocatorFactory(physicalSlotProvider, DEFAULT_TIMEOUT);
    }

    public static SlotSharingExecutionSlotAllocatorFactory newSlotSharingExecutionSlotAllocatorFactory(PhysicalSlotProvider physicalSlotProvider, Time allocationTimeout) {
        return new SlotSharingExecutionSlotAllocatorFactory(physicalSlotProvider, true, (PhysicalSlotRequestBulkChecker)new TestingPhysicalSlotRequestBulkChecker(), allocationTimeout, (SlotSharingStrategy.Factory)new LocalInputPreferredSlotSharingStrategy.Factory());
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    static /* synthetic */ Time access$100() {
        return DEFAULT_TIMEOUT;
    }

    public static class DefaultSchedulerBuilder {
        private final JobGraph jobGraph;
        private final ComponentMainThreadExecutor mainThreadExecutor;
        private SchedulingStrategyFactory schedulingStrategyFactory = new PipelinedRegionSchedulingStrategy.Factory();
        private Logger log = SchedulerTestingUtils.access$000();
        private Executor ioExecutor = TestingUtils.defaultExecutor();
        private Configuration jobMasterConfiguration = new Configuration();
        private ScheduledExecutorService futureExecutor = TestingUtils.defaultExecutor();
        private ScheduledExecutor delayExecutor = new ScheduledExecutorServiceAdapter(this.futureExecutor);
        private ClassLoader userCodeLoader = ClassLoader.getSystemClassLoader();
        private CheckpointRecoveryFactory checkpointRecoveryFactory = new StandaloneCheckpointRecoveryFactory();
        private Time rpcTimeout = SchedulerTestingUtils.access$100();
        private BlobWriter blobWriter = VoidBlobWriter.getInstance();
        private JobManagerJobMetricGroup jobManagerJobMetricGroup = UnregisteredMetricGroups.createUnregisteredJobManagerJobMetricGroup();
        private ShuffleMaster<?> shuffleMaster = NettyShuffleMaster.INSTANCE;
        private JobMasterPartitionTracker partitionTracker = NoOpJobMasterPartitionTracker.INSTANCE;
        private FailoverStrategy.Factory failoverStrategyFactory = new RestartPipelinedRegionFailoverStrategy.Factory();
        private RestartBackoffTimeStrategy restartBackoffTimeStrategy = NoRestartBackoffTimeStrategy.INSTANCE;
        private ExecutionVertexOperations executionVertexOperations = new DefaultExecutionVertexOperations();
        private ExecutionVertexVersioner executionVertexVersioner = new ExecutionVertexVersioner();
        private ExecutionSlotAllocatorFactory executionSlotAllocatorFactory = new TestExecutionSlotAllocatorFactory();
        private JobStatusListener jobStatusListener = (ignoredA, ignoredB, ignoredC, ignoredD) -> {};

        public DefaultSchedulerBuilder(JobGraph jobGraph, ComponentMainThreadExecutor mainThreadExecutor) {
            this.jobGraph = jobGraph;
            this.mainThreadExecutor = mainThreadExecutor;
        }

        public DefaultSchedulerBuilder setLogger(Logger log) {
            this.log = log;
            return this;
        }

        public DefaultSchedulerBuilder setIoExecutor(Executor ioExecutor) {
            this.ioExecutor = ioExecutor;
            return this;
        }

        public DefaultSchedulerBuilder setJobMasterConfiguration(Configuration jobMasterConfiguration) {
            this.jobMasterConfiguration = jobMasterConfiguration;
            return this;
        }

        public DefaultSchedulerBuilder setFutureExecutor(ScheduledExecutorService futureExecutor) {
            this.futureExecutor = futureExecutor;
            return this;
        }

        public DefaultSchedulerBuilder setDelayExecutor(ScheduledExecutor delayExecutor) {
            this.delayExecutor = delayExecutor;
            return this;
        }

        public DefaultSchedulerBuilder setUserCodeLoader(ClassLoader userCodeLoader) {
            this.userCodeLoader = userCodeLoader;
            return this;
        }

        public DefaultSchedulerBuilder setCheckpointRecoveryFactory(CheckpointRecoveryFactory checkpointRecoveryFactory) {
            this.checkpointRecoveryFactory = checkpointRecoveryFactory;
            return this;
        }

        public DefaultSchedulerBuilder setRpcTimeout(Time rpcTimeout) {
            this.rpcTimeout = rpcTimeout;
            return this;
        }

        public DefaultSchedulerBuilder setBlobWriter(BlobWriter blobWriter) {
            this.blobWriter = blobWriter;
            return this;
        }

        public DefaultSchedulerBuilder setJobManagerJobMetricGroup(JobManagerJobMetricGroup jobManagerJobMetricGroup) {
            this.jobManagerJobMetricGroup = jobManagerJobMetricGroup;
            return this;
        }

        public DefaultSchedulerBuilder setShuffleMaster(ShuffleMaster<?> shuffleMaster) {
            this.shuffleMaster = shuffleMaster;
            return this;
        }

        public DefaultSchedulerBuilder setPartitionTracker(JobMasterPartitionTracker partitionTracker) {
            this.partitionTracker = partitionTracker;
            return this;
        }

        public DefaultSchedulerBuilder setSchedulingStrategyFactory(SchedulingStrategyFactory schedulingStrategyFactory) {
            this.schedulingStrategyFactory = schedulingStrategyFactory;
            return this;
        }

        public DefaultSchedulerBuilder setFailoverStrategyFactory(FailoverStrategy.Factory failoverStrategyFactory) {
            this.failoverStrategyFactory = failoverStrategyFactory;
            return this;
        }

        public DefaultSchedulerBuilder setRestartBackoffTimeStrategy(RestartBackoffTimeStrategy restartBackoffTimeStrategy) {
            this.restartBackoffTimeStrategy = restartBackoffTimeStrategy;
            return this;
        }

        public DefaultSchedulerBuilder setExecutionVertexOperations(ExecutionVertexOperations executionVertexOperations) {
            this.executionVertexOperations = executionVertexOperations;
            return this;
        }

        public DefaultSchedulerBuilder setExecutionVertexVersioner(ExecutionVertexVersioner executionVertexVersioner) {
            this.executionVertexVersioner = executionVertexVersioner;
            return this;
        }

        public DefaultSchedulerBuilder setExecutionSlotAllocatorFactory(ExecutionSlotAllocatorFactory executionSlotAllocatorFactory) {
            this.executionSlotAllocatorFactory = executionSlotAllocatorFactory;
            return this;
        }

        public DefaultSchedulerBuilder setJobStatusListener(JobStatusListener jobStatusListener) {
            this.jobStatusListener = jobStatusListener;
            return this;
        }

        public DefaultScheduler build() throws Exception {
            DefaultExecutionGraphFactory executionGraphFactory = new DefaultExecutionGraphFactory(this.jobMasterConfiguration, this.userCodeLoader, (ExecutionDeploymentTracker)new DefaultExecutionDeploymentTracker(), this.futureExecutor, this.ioExecutor, this.rpcTimeout, this.jobManagerJobMetricGroup, this.blobWriter, this.shuffleMaster, this.partitionTracker);
            return new DefaultScheduler(this.log, this.jobGraph, this.ioExecutor, this.jobMasterConfiguration, componentMainThreadExecutor -> {}, this.delayExecutor, this.userCodeLoader, this.checkpointRecoveryFactory, this.jobManagerJobMetricGroup, this.schedulingStrategyFactory, this.failoverStrategyFactory, this.restartBackoffTimeStrategy, this.executionVertexOperations, this.executionVertexVersioner, this.executionSlotAllocatorFactory, System.currentTimeMillis(), this.mainThreadExecutor, this.jobStatusListener, (ExecutionGraphFactory)executionGraphFactory);
        }
    }

    private static final class TaskExecutorOperatorEventGatewayAdapter
    extends SimpleAckingTaskManagerGateway {
        private final TaskExecutorOperatorEventGateway operatorGateway;

        TaskExecutorOperatorEventGatewayAdapter(TaskExecutorOperatorEventGateway operatorGateway) {
            this.operatorGateway = operatorGateway;
        }

        @Override
        public CompletableFuture<Acknowledge> sendOperatorEventToTask(ExecutionAttemptID task, OperatorID operator, SerializedValue<OperatorEvent> evt) {
            return this.operatorGateway.sendOperatorEventToTask(task, operator, evt);
        }
    }
}

