/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.akka;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.japi.pf.ReceiveBuilder;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.junit.Test;

public class AkkaActorSystemTest
extends TestLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shutsDownOnActorFailure() {
        ActorSystem actorSystem = AkkaUtils.createLocalActorSystem((Configuration)new Configuration());
        try {
            CompletableFuture terminationFuture = actorSystem.getWhenTerminated().toCompletableFuture();
            ActorRef actorRef = actorSystem.actorOf(Props.create(SimpleActor.class, (Object[])new Object[0]));
            FlinkException cause = new FlinkException("Flink test exception");
            actorRef.tell((Object)Fail.exceptionally(cause), ActorRef.noSender());
            terminationFuture.join();
        }
        finally {
            AkkaUtils.terminateActorSystem((ActorSystem)actorSystem).join();
        }
    }

    private static final class Fail {
        private final Throwable errorCause;

        private Fail(Throwable errorCause) {
            this.errorCause = errorCause;
        }

        private Throwable getErrorCause() {
            return this.errorCause;
        }

        private static Fail exceptionally(Throwable errorCause) {
            return new Fail(errorCause);
        }
    }

    private static final class SimpleActor
    extends AbstractActor {
        private SimpleActor() {
        }

        public AbstractActor.Receive createReceive() {
            return ReceiveBuilder.create().match(Fail.class, this::handleFail).build();
        }

        private void handleFail(Fail fail) {
            throw new RuntimeException(fail.getErrorCause());
        }
    }
}

