/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.metrics.dump.MetricDump;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.TaskManagerInfoWithSlots;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.handler.taskmanager.TaskManagerDetailsHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerDetailsHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerDetailsInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerFileMessageParameters;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMessageParameters;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMetricsInfo;
import org.apache.flink.runtime.taskexecutor.TaskExecutorMemoryConfiguration;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

public class TaskManagerDetailsHandlerTest
extends TestLogger {
    private static final ResourceID TASK_MANAGER_ID = ResourceID.generate();
    private TestingResourceManagerGateway resourceManagerGateway;
    private MetricFetcher metricFetcher;
    private TaskManagerDetailsHandler testInstance;

    @Before
    public void setup() throws HandlerRequestException {
        this.resourceManagerGateway = new TestingResourceManagerGateway();
        this.metricFetcher = new TestingMetricFetcher();
        this.testInstance = new TaskManagerDetailsHandler(() -> CompletableFuture.completedFuture(null), TestingUtils.TIMEOUT(), Collections.emptyMap(), (MessageHeaders)TaskManagerDetailsHeaders.getInstance(), () -> CompletableFuture.completedFuture(this.resourceManagerGateway), this.metricFetcher);
    }

    @Test
    public void testTaskManagerMetricsInfoExtraction() throws RestHandlerException, ExecutionException, InterruptedException, JsonProcessingException, HandlerRequestException {
        TaskManagerDetailsHandlerTest.initializeMetricStore(this.metricFetcher.getMetricStore());
        this.resourceManagerGateway.setRequestTaskManagerDetailsInfoFunction(taskManagerId -> CompletableFuture.completedFuture(new TaskManagerInfoWithSlots(TaskManagerDetailsHandlerTest.createEmptyTaskManagerInfo(), Collections.emptyList())));
        HandlerRequest<EmptyRequestBody, TaskManagerMessageParameters> request = TaskManagerDetailsHandlerTest.createRequest();
        TaskManagerDetailsInfo taskManagerDetailsInfo = (TaskManagerDetailsInfo)this.testInstance.handleRequest(request, (ResourceManagerGateway)this.resourceManagerGateway).get();
        TaskManagerMetricsInfo actual = taskManagerDetailsInfo.getTaskManagerMetricsInfo();
        TaskManagerMetricsInfo expected = new TaskManagerMetricsInfo(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 15L, 16L, 17L, 18L, 19L, 20L, Collections.emptyList());
        ObjectMapper objectMapper = new ObjectMapper();
        String actualJson = objectMapper.writeValueAsString((Object)actual);
        String expectedJson = objectMapper.writeValueAsString((Object)expected);
        MatcherAssert.assertThat((Object)actualJson, (Matcher)CoreMatchers.is((Object)expectedJson));
    }

    private static void initializeMetricStore(MetricStore metricStore) {
        QueryScopeInfo.TaskManagerQueryScopeInfo tmScope = new QueryScopeInfo.TaskManagerQueryScopeInfo(TASK_MANAGER_ID.toString(), "Status");
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)tmScope, "JVM.Memory.Heap.Used", 1L));
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)tmScope, "JVM.Memory.Heap.Committed", 2L));
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)tmScope, "JVM.Memory.Heap.Max", 3L));
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)tmScope, "JVM.Memory.NonHeap.Used", 4L));
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)tmScope, "JVM.Memory.NonHeap.Committed", 5L));
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)tmScope, "JVM.Memory.NonHeap.Max", 6L));
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)tmScope, "JVM.Memory.Direct.Count", 7L));
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)tmScope, "JVM.Memory.Direct.MemoryUsed", 8L));
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)tmScope, "JVM.Memory.Direct.TotalCapacity", 9L));
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)tmScope, "JVM.Memory.Mapped.Count", 10L));
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)tmScope, "JVM.Memory.Mapped.MemoryUsed", 11L));
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)tmScope, "JVM.Memory.Mapped.TotalCapacity", 12L));
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)tmScope, "Network.AvailableMemorySegments", 13L));
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)tmScope, "Network.TotalMemorySegments", 14L));
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)tmScope, "Shuffle.Netty.AvailableMemorySegments", 15L));
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)tmScope, "Shuffle.Netty.UsedMemorySegments", 16L));
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)tmScope, "Shuffle.Netty.TotalMemorySegments", 17L));
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)tmScope, "Shuffle.Netty.AvailableMemory", 18L));
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)tmScope, "Shuffle.Netty.UsedMemory", 19L));
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)tmScope, "Shuffle.Netty.TotalMemory", 20L));
    }

    private static TaskManagerInfo createEmptyTaskManagerInfo() {
        return new TaskManagerInfo(TASK_MANAGER_ID, UUID.randomUUID().toString(), 0, 0, 0L, 0, 0, ResourceProfile.ZERO, ResourceProfile.ZERO, new HardwareDescription(0, 0L, 0L, 0L), new TaskExecutorMemoryConfiguration(Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L)));
    }

    private static HandlerRequest<EmptyRequestBody, TaskManagerMessageParameters> createRequest() throws HandlerRequestException {
        HashMap<String, String> pathParameters = new HashMap<String, String>();
        pathParameters.put("taskmanagerid", TASK_MANAGER_ID.toString());
        return new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new TaskManagerFileMessageParameters(), pathParameters, Collections.emptyMap());
    }

    private static class TestingMetricFetcher
    implements MetricFetcher {
        private final MetricStore metricStore = new MetricStore();

        private TestingMetricFetcher() {
        }

        public MetricStore getMetricStore() {
            return this.metricStore;
        }

        public void update() {
        }

        public long getLastUpdateTime() {
            return 0L;
        }
    }
}

