/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.FineGrainedTaskManagerTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManagerId;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotState;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerInfo;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;
import org.apache.flink.runtime.util.ResourceCounter;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class FineGrainedTaskManagerTrackerTest
extends TestLogger {
    private static final TaskExecutorConnection TASK_EXECUTOR_CONNECTION = new TaskExecutorConnection(ResourceID.generate(), (TaskExecutorGateway)new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway());

    @Test
    public void testInitState() {
        FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
        Assert.assertThat((Object)taskManagerTracker.getPendingTaskManagers(), (Matcher)Is.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)taskManagerTracker.getRegisteredTaskManagers(), (Matcher)Is.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testAddAndRemoveTaskManager() {
        FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
        taskManagerTracker.addTaskManager(TASK_EXECUTOR_CONNECTION, ResourceProfile.ANY, ResourceProfile.ANY);
        Assert.assertThat((Object)taskManagerTracker.getRegisteredTaskManagers().size(), (Matcher)Is.is((Object)1));
        Assert.assertTrue((boolean)taskManagerTracker.getRegisteredTaskManager(TASK_EXECUTOR_CONNECTION.getInstanceID()).isPresent());
        taskManagerTracker.removeTaskManager(TASK_EXECUTOR_CONNECTION.getInstanceID());
        Assert.assertThat((Object)taskManagerTracker.getRegisteredTaskManagers().size(), (Matcher)Is.is((Object)0));
    }

    @Test(expected=NullPointerException.class)
    public void testRemoveUnknownTaskManager() {
        FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
        taskManagerTracker.removeTaskManager(new InstanceID());
    }

    @Test
    public void testAddAndRemovePendingTaskManager() {
        PendingTaskManager pendingTaskManager = new PendingTaskManager(ResourceProfile.ANY, 1);
        FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
        JobID jobId = new JobID();
        ResourceCounter resourceCounter = ResourceCounter.withResource((ResourceProfile)ResourceProfile.ANY, (int)1);
        taskManagerTracker.addPendingTaskManager(pendingTaskManager);
        taskManagerTracker.replaceAllPendingAllocations(Collections.singletonMap(pendingTaskManager.getPendingTaskManagerId(), Collections.singletonMap(jobId, resourceCounter)));
        Assert.assertThat((Object)taskManagerTracker.getPendingTaskManagers().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)taskManagerTracker.getPendingTaskManagersByTotalAndDefaultSlotResourceProfile(ResourceProfile.ANY, ResourceProfile.ANY).size(), (Matcher)Is.is((Object)1));
        Map records = taskManagerTracker.removePendingTaskManager(pendingTaskManager.getPendingTaskManagerId());
        Assert.assertThat((Object)taskManagerTracker.getPendingTaskManagers(), (Matcher)Is.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)taskManagerTracker.getPendingAllocationsOfPendingTaskManager(pendingTaskManager.getPendingTaskManagerId()).size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)taskManagerTracker.getPendingTaskManagersByTotalAndDefaultSlotResourceProfile(ResourceProfile.ANY, ResourceProfile.ANY).size(), (Matcher)Is.is((Object)0));
        Assert.assertTrue((boolean)records.containsKey(jobId));
        Assert.assertThat((Object)((ResourceCounter)records.get(jobId)).getResourceCount(ResourceProfile.ANY), (Matcher)Is.is((Object)1));
    }

    @Test(expected=NullPointerException.class)
    public void testRemoveUnknownPendingTaskManager() {
        FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
        taskManagerTracker.removePendingTaskManager(PendingTaskManagerId.generate());
    }

    @Test
    public void testSlotAllocation() {
        FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
        ResourceProfile totalResource = ResourceProfile.fromResources((double)10.0, (int)1000);
        AllocationID allocationId1 = new AllocationID();
        AllocationID allocationId2 = new AllocationID();
        JobID jobId = new JobID();
        taskManagerTracker.addTaskManager(TASK_EXECUTOR_CONNECTION, totalResource, totalResource);
        taskManagerTracker.notifySlotStatus(allocationId1, jobId, TASK_EXECUTOR_CONNECTION.getInstanceID(), ResourceProfile.fromResources((double)3.0, (int)200), SlotState.PENDING);
        Assert.assertTrue((boolean)taskManagerTracker.getAllocatedOrPendingSlot(allocationId1).isPresent());
        Assert.assertThat((Object)((TaskManagerInfo)taskManagerTracker.getRegisteredTaskManager(TASK_EXECUTOR_CONNECTION.getInstanceID()).get()).getAvailableResource(), (Matcher)Is.is((Object)ResourceProfile.fromResources((double)7.0, (int)800)));
        taskManagerTracker.notifySlotStatus(allocationId1, jobId, TASK_EXECUTOR_CONNECTION.getInstanceID(), ResourceProfile.fromResources((double)3.0, (int)200), SlotState.ALLOCATED);
        Assert.assertTrue((boolean)taskManagerTracker.getAllocatedOrPendingSlot(allocationId1).isPresent());
        Assert.assertThat((Object)((TaskManagerInfo)taskManagerTracker.getRegisteredTaskManager(TASK_EXECUTOR_CONNECTION.getInstanceID()).get()).getAvailableResource(), (Matcher)Is.is((Object)ResourceProfile.fromResources((double)7.0, (int)800)));
        taskManagerTracker.notifySlotStatus(allocationId2, jobId, TASK_EXECUTOR_CONNECTION.getInstanceID(), ResourceProfile.fromResources((double)2.0, (int)300), SlotState.ALLOCATED);
        Assert.assertTrue((boolean)taskManagerTracker.getAllocatedOrPendingSlot(allocationId2).isPresent());
        Assert.assertThat((Object)((TaskManagerInfo)taskManagerTracker.getRegisteredTaskManager(TASK_EXECUTOR_CONNECTION.getInstanceID()).get()).getAvailableResource(), (Matcher)Is.is((Object)ResourceProfile.fromResources((double)5.0, (int)500)));
    }

    @Test
    public void testFreeSlot() {
        FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
        ResourceProfile totalResource = ResourceProfile.fromResources((double)10.0, (int)1000);
        AllocationID allocationId1 = new AllocationID();
        AllocationID allocationId2 = new AllocationID();
        JobID jobId = new JobID();
        taskManagerTracker.addTaskManager(TASK_EXECUTOR_CONNECTION, totalResource, totalResource);
        taskManagerTracker.notifySlotStatus(allocationId1, jobId, TASK_EXECUTOR_CONNECTION.getInstanceID(), ResourceProfile.fromResources((double)3.0, (int)200), SlotState.PENDING);
        taskManagerTracker.notifySlotStatus(allocationId2, jobId, TASK_EXECUTOR_CONNECTION.getInstanceID(), ResourceProfile.fromResources((double)2.0, (int)300), SlotState.ALLOCATED);
        taskManagerTracker.notifySlotStatus(allocationId1, jobId, TASK_EXECUTOR_CONNECTION.getInstanceID(), ResourceProfile.fromResources((double)3.0, (int)200), SlotState.FREE);
        Assert.assertFalse((boolean)taskManagerTracker.getAllocatedOrPendingSlot(allocationId1).isPresent());
        Assert.assertThat((Object)((TaskManagerInfo)taskManagerTracker.getRegisteredTaskManager(TASK_EXECUTOR_CONNECTION.getInstanceID()).get()).getAvailableResource(), (Matcher)Is.is((Object)ResourceProfile.fromResources((double)8.0, (int)700)));
        taskManagerTracker.notifySlotStatus(allocationId2, jobId, TASK_EXECUTOR_CONNECTION.getInstanceID(), ResourceProfile.fromResources((double)2.0, (int)300), SlotState.FREE);
        Assert.assertFalse((boolean)taskManagerTracker.getAllocatedOrPendingSlot(allocationId2).isPresent());
        Assert.assertThat((Object)((TaskManagerInfo)taskManagerTracker.getRegisteredTaskManager(TASK_EXECUTOR_CONNECTION.getInstanceID()).get()).getAvailableResource(), (Matcher)Is.is((Object)totalResource));
    }

    @Test(expected=NullPointerException.class)
    public void testFreeUnknownSlot() {
        FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
        taskManagerTracker.notifySlotStatus(new AllocationID(), new JobID(), new InstanceID(), ResourceProfile.ANY, SlotState.FREE);
    }

    @Test
    public void testRecordPendingAllocations() {
        FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
        PendingTaskManager pendingTaskManager1 = new PendingTaskManager(ResourceProfile.ANY, 1);
        PendingTaskManager pendingTaskManager2 = new PendingTaskManager(ResourceProfile.ANY, 1);
        JobID jobId = new JobID();
        ResourceCounter resourceCounter = ResourceCounter.withResource((ResourceProfile)ResourceProfile.ANY, (int)1);
        taskManagerTracker.addPendingTaskManager(pendingTaskManager1);
        taskManagerTracker.addPendingTaskManager(pendingTaskManager2);
        taskManagerTracker.replaceAllPendingAllocations(Collections.singletonMap(pendingTaskManager1.getPendingTaskManagerId(), Collections.singletonMap(jobId, resourceCounter)));
        taskManagerTracker.replaceAllPendingAllocations(Collections.singletonMap(pendingTaskManager2.getPendingTaskManagerId(), Collections.singletonMap(jobId, resourceCounter)));
        Assert.assertThat((Object)taskManagerTracker.getPendingAllocationsOfPendingTaskManager(pendingTaskManager1.getPendingTaskManagerId()).size(), (Matcher)Is.is((Object)0));
        Assert.assertTrue((boolean)taskManagerTracker.getPendingAllocationsOfPendingTaskManager(pendingTaskManager2.getPendingTaskManagerId()).containsKey(jobId));
        Assert.assertThat((Object)((ResourceCounter)taskManagerTracker.getPendingAllocationsOfPendingTaskManager(pendingTaskManager2.getPendingTaskManagerId()).get(jobId)).getResourceCount(ResourceProfile.ANY), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testGetStatistics() {
        FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
        ResourceProfile totalResource = ResourceProfile.fromResources((double)10.0, (int)1000);
        ResourceProfile defaultSlotResource = ResourceProfile.fromResources((double)1.0, (int)100);
        AllocationID allocationId1 = new AllocationID();
        AllocationID allocationId2 = new AllocationID();
        JobID jobId = new JobID();
        taskManagerTracker.addTaskManager(TASK_EXECUTOR_CONNECTION, totalResource, defaultSlotResource);
        taskManagerTracker.notifySlotStatus(allocationId1, jobId, TASK_EXECUTOR_CONNECTION.getInstanceID(), ResourceProfile.fromResources((double)3.0, (int)200), SlotState.ALLOCATED);
        taskManagerTracker.notifySlotStatus(allocationId2, jobId, TASK_EXECUTOR_CONNECTION.getInstanceID(), defaultSlotResource, SlotState.ALLOCATED);
        taskManagerTracker.addPendingTaskManager(new PendingTaskManager(ResourceProfile.fromResources((double)4.0, (int)200), 1));
        Assert.assertThat((Object)taskManagerTracker.getFreeResource(), (Matcher)Is.is((Object)ResourceProfile.fromResources((double)6.0, (int)700)));
        Assert.assertThat((Object)taskManagerTracker.getRegisteredResource(), (Matcher)Is.is((Object)totalResource));
        Assert.assertThat((Object)taskManagerTracker.getNumberRegisteredSlots(), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)taskManagerTracker.getNumberFreeSlots(), (Matcher)Is.is((Object)8));
        Assert.assertThat((Object)taskManagerTracker.getPendingResource(), (Matcher)Is.is((Object)ResourceProfile.fromResources((double)4.0, (int)200)));
    }
}

