/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.io.network.partition.NoOpResourceManagerPartitionTracker;
import org.apache.flink.runtime.metrics.groups.ResourceManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.StandaloneResourceManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingSlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingSlotManagerBuilder;
import org.apache.flink.runtime.resourcemanager.utils.MockResourceManagerRuntimeServices;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.TestingRpcServiceResource;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class StandaloneResourceManagerTest
extends TestLogger {
    @ClassRule
    public static final TestingRpcServiceResource RPC_SERVICE = new TestingRpcServiceResource();
    private static final Time TIMEOUT = Time.seconds((long)10L);
    private final TestingFatalErrorHandler fatalErrorHandler = new TestingFatalErrorHandler();

    @Test
    public void testStartupPeriod() throws Exception {
        LinkedBlockingQueue setFailUnfulfillableRequestInvokes = new LinkedBlockingQueue();
        TestingSlotManager slotManager = new TestingSlotManagerBuilder().setSetFailUnfulfillableRequestConsumer(setFailUnfulfillableRequestInvokes::add).createSlotManager();
        TestingStandaloneResourceManager rm = this.createResourceManager(Time.milliseconds((long)1L), slotManager);
        Assert.assertThat(setFailUnfulfillableRequestInvokes.take(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat(setFailUnfulfillableRequestInvokes.take(), (Matcher)CoreMatchers.is((Object)true));
        rm.close();
    }

    @Test
    public void testNoStartupPeriod() throws Exception {
        LinkedBlockingQueue setFailUnfulfillableRequestInvokes = new LinkedBlockingQueue();
        TestingSlotManager slotManager = new TestingSlotManagerBuilder().setSetFailUnfulfillableRequestConsumer(setFailUnfulfillableRequestInvokes::add).createSlotManager();
        TestingStandaloneResourceManager rm = this.createResourceManager(Time.milliseconds((long)-1L), slotManager);
        Assert.assertThat(setFailUnfulfillableRequestInvokes.take(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat(setFailUnfulfillableRequestInvokes.poll(50L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Matcher)IsNull.nullValue()));
        rm.close();
    }

    @Test
    public void testStartUpPeriodAfterLeadershipSwitch() throws Exception {
        LinkedBlockingQueue setFailUnfulfillableRequestInvokes = new LinkedBlockingQueue();
        TestingSlotManager slotManager = new TestingSlotManagerBuilder().setSetFailUnfulfillableRequestConsumer(setFailUnfulfillableRequestInvokes::add).createSlotManager();
        TestingStandaloneResourceManager rm = this.createResourceManager(Time.milliseconds((long)1L), slotManager);
        Assert.assertThat(setFailUnfulfillableRequestInvokes.take(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat(setFailUnfulfillableRequestInvokes.take(), (Matcher)CoreMatchers.is((Object)true));
        rm.rmServices.revokeLeadership();
        rm.rmServices.grantLeadership();
        Assert.assertThat(setFailUnfulfillableRequestInvokes.take(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat(setFailUnfulfillableRequestInvokes.take(), (Matcher)CoreMatchers.is((Object)true));
    }

    private TestingStandaloneResourceManager createResourceManager(Time startupPeriod, SlotManager slotManager) throws Exception {
        MockResourceManagerRuntimeServices rmServices = new MockResourceManagerRuntimeServices((RpcService)RPC_SERVICE.getTestingRpcService(), TIMEOUT, slotManager);
        TestingStandaloneResourceManager rm = new TestingStandaloneResourceManager(rmServices.rpcService, ResourceID.generate(), rmServices.highAvailabilityServices, rmServices.heartbeatServices, rmServices.slotManager, rmServices.jobLeaderIdService, new ClusterInformation("localhost", 1234), this.fatalErrorHandler, UnregisteredMetricGroups.createUnregisteredResourceManagerMetricGroup(), startupPeriod, rmServices);
        rm.start();
        rmServices.grantLeadership();
        return rm;
    }

    private static class TestingStandaloneResourceManager
    extends StandaloneResourceManager {
        private final MockResourceManagerRuntimeServices rmServices;

        private TestingStandaloneResourceManager(RpcService rpcService, ResourceID resourceId, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, SlotManager slotManager, JobLeaderIdService jobLeaderIdService, ClusterInformation clusterInformation, FatalErrorHandler fatalErrorHandler, ResourceManagerMetricGroup resourceManagerMetricGroup, Time startupPeriodTime, MockResourceManagerRuntimeServices rmServices) {
            super(rpcService, resourceId, highAvailabilityServices, heartbeatServices, slotManager, NoOpResourceManagerPartitionTracker::get, jobLeaderIdService, clusterInformation, fatalErrorHandler, resourceManagerMetricGroup, startupPeriodTime, RpcUtils.INF_TIMEOUT, (Executor)ForkJoinPool.commonPool());
            this.rmServices = rmServices;
        }
    }
}

