/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolImpl;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolUtils;
import org.apache.flink.runtime.jobmaster.slotpool.TestingSlotPoolImpl;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.SlotRequest;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.CheckedSupplier;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class SlotPoolRequestCompletionTest
extends TestLogger {
    private static final Time TIMEOUT = SlotPoolUtils.TIMEOUT;
    private TestingResourceManagerGateway resourceManagerGateway;

    @Before
    public void setUp() throws Exception {
        this.resourceManagerGateway = new TestingResourceManagerGateway();
    }

    @Test
    public void testRequestsAreCompletedInRequestOrder() {
        this.runSlotRequestCompletionTest(CheckedSupplier.unchecked(this::createAndSetUpSlotPool), slotPool -> {});
    }

    @Test
    public void testStashOrderMaintainsRequestOrder() {
        this.runSlotRequestCompletionTest(CheckedSupplier.unchecked(this::createAndSetUpSlotPoolWithoutResourceManager), this::connectToResourceManager);
    }

    private void runSlotRequestCompletionTest(Supplier<SlotPoolImpl> slotPoolSupplier, Consumer<SlotPoolImpl> actionAfterSlotRequest) {
        try (SlotPoolImpl slotPool = slotPoolSupplier.get();){
            int requestNum = 10;
            List slotRequestIds = IntStream.range(0, 10).mapToObj(ignored -> new SlotRequestId()).collect(Collectors.toList());
            ArrayList rmReceivedSlotRequests = new ArrayList(10);
            this.resourceManagerGateway.setRequestSlotConsumer(request -> rmReceivedSlotRequests.add(request));
            List slotRequests = slotRequestIds.stream().map(slotRequestId -> slotPool.requestNewAllocatedSlot(slotRequestId, ResourceProfile.UNKNOWN, TIMEOUT)).collect(Collectors.toList());
            actionAfterSlotRequest.accept(slotPool);
            LocalTaskManagerLocation taskManagerLocation = new LocalTaskManagerLocation();
            slotPool.registerTaskManager(taskManagerLocation.getResourceID());
            AllocationID lastAllocationId = ((SlotRequest)rmReceivedSlotRequests.get(9)).getAllocationId();
            SlotOffer slotOffer = new SlotOffer(lastAllocationId, 0, ResourceProfile.ANY);
            Collection acceptedSlots = slotPool.offerSlots((TaskManagerLocation)taskManagerLocation, (TaskManagerGateway)new SimpleAckingTaskManagerGateway(), Collections.singleton(slotOffer));
            MatcherAssert.assertThat((Object)acceptedSlots, (Matcher)Matchers.containsInAnyOrder((Object[])new SlotOffer[]{slotOffer}));
            FlinkException testingReleaseException = new FlinkException("Testing release exception");
            for (int i = 0; i < slotRequestIds.size(); ++i) {
                CompletableFuture slotRequestFuture = (CompletableFuture)slotRequests.get(i);
                MatcherAssert.assertThat(slotRequestFuture.getNow(null), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
                slotPool.releaseSlot((SlotRequestId)slotRequestIds.get(i), (Throwable)testingReleaseException);
            }
        }
    }

    private TestingSlotPoolImpl createAndSetUpSlotPool() throws Exception {
        return SlotPoolUtils.createAndSetUpSlotPool(this.resourceManagerGateway);
    }

    private void connectToResourceManager(SlotPoolImpl slotPool) {
        slotPool.connectToResourceManager((ResourceManagerGateway)this.resourceManagerGateway);
    }

    private TestingSlotPoolImpl createAndSetUpSlotPoolWithoutResourceManager() throws Exception {
        return SlotPoolUtils.createAndSetUpSlotPool(null);
    }
}

