/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProviderImpl;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProviderResource;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequest;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolBuilder;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.TestingSlotPoolImpl;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class PhysicalSlotProviderImplWithDefaultSlotSelectionStrategyTest {
    @Rule
    public final PhysicalSlotProviderResource physicalSlotProviderResource = new PhysicalSlotProviderResource((SlotSelectionStrategy)LocationPreferenceSlotSelectionStrategy.createDefault());

    @Test
    public void testSlotAllocationFulfilledWithAvailableSlots() throws InterruptedException, ExecutionException {
        PhysicalSlotRequest request = this.physicalSlotProviderResource.createSimpleRequest();
        this.physicalSlotProviderResource.registerSlotOffersFromNewTaskExecutor(ResourceProfile.ANY);
        CompletableFuture<PhysicalSlotRequest.Result> slotFuture = this.physicalSlotProviderResource.allocateSlot(request);
        PhysicalSlotRequest.Result result = slotFuture.get();
        Assert.assertThat((Object)result.getSlotRequestId(), (Matcher)Matchers.is((Object)request.getSlotRequestId()));
    }

    @Test
    public void testSlotAllocationFulfilledWithNewSlots() throws ExecutionException, InterruptedException {
        CompletableFuture<PhysicalSlotRequest.Result> slotFuture = this.physicalSlotProviderResource.allocateSlot(this.physicalSlotProviderResource.createSimpleRequest());
        Assert.assertThat((Object)slotFuture.isDone(), (Matcher)Matchers.is((Object)false));
        this.physicalSlotProviderResource.registerSlotOffersFromNewTaskExecutor(ResourceProfile.ANY);
        slotFuture.get();
    }

    @Test
    public void testIndividualBatchSlotRequestTimeoutCheckIsDisabledOnAllocatingNewSlots() throws Exception {
        TestingSlotPoolImpl slotPool = new SlotPoolBuilder(this.physicalSlotProviderResource.getMainThreadExecutor()).build();
        Assert.assertThat((Object)slotPool.isBatchSlotRequestTimeoutCheckEnabled(), (Matcher)Matchers.is((Object)true));
        new PhysicalSlotProviderImpl((SlotSelectionStrategy)LocationPreferenceSlotSelectionStrategy.createDefault(), (SlotPool)slotPool);
        Assert.assertThat((Object)slotPool.isBatchSlotRequestTimeoutCheckEnabled(), (Matcher)Matchers.is((Object)false));
    }
}

