/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderAndConsumerTest;
import org.apache.flink.runtime.io.network.buffer.BufferConsumerWithPartialRecordLength;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.partition.PrioritizedDeque;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class BufferConsumerWithPartialRecordLengthTest {
    private static final int BUFFER_INT_SIZE = 4;
    private static final int BUFFER_SIZE = 16;
    private final PrioritizedDeque<BufferConsumerWithPartialRecordLength> buffers = new PrioritizedDeque();
    private BufferBuilder builder = null;

    @After
    public void clear() {
        this.buffers.clear();
        this.builder = null;
    }

    @Test
    public void partialRecordTestCase() {
        this.writeToBuffer(BufferBuilderAndConsumerTest.toByteBuffer(0, 1, 2, 3, 42));
        Assert.assertEquals((long)this.buffers.size(), (long)2L);
        BufferConsumerWithPartialRecordLength consumer1 = (BufferConsumerWithPartialRecordLength)this.buffers.poll();
        Assert.assertEquals((long)0L, (long)Objects.requireNonNull(consumer1).getPartialRecordLength());
        Assert.assertTrue((boolean)consumer1.cleanupPartialRecord());
        BufferBuilderAndConsumerTest.assertContent(consumer1.build(), FreeingBufferRecycler.INSTANCE, 0, 1, 2, 3);
        BufferConsumerWithPartialRecordLength consumer2 = (BufferConsumerWithPartialRecordLength)this.buffers.poll();
        Assert.assertTrue((boolean)Objects.requireNonNull(consumer2).cleanupPartialRecord());
        Assert.assertEquals((long)consumer2.build().readableBytes(), (long)0L);
    }

    @Test
    public void partialLongRecordSpanningBufferTestCase() {
        this.writeToBuffer(BufferBuilderAndConsumerTest.toByteBuffer(0, 1, 2, 3, 4, 5, 6, 7, 42));
        this.writeToBuffer(BufferBuilderAndConsumerTest.toByteBuffer(8, 9));
        Assert.assertEquals((long)this.buffers.size(), (long)3L);
        this.buffers.poll();
        BufferConsumerWithPartialRecordLength consumer2 = (BufferConsumerWithPartialRecordLength)this.buffers.poll();
        Assert.assertEquals((long)16L, (long)Objects.requireNonNull(consumer2).getPartialRecordLength());
        Assert.assertFalse((boolean)consumer2.cleanupPartialRecord());
        Assert.assertEquals((long)consumer2.build().readableBytes(), (long)0L);
        BufferConsumerWithPartialRecordLength consumer3 = (BufferConsumerWithPartialRecordLength)this.buffers.poll();
        Assert.assertTrue((boolean)Objects.requireNonNull(consumer3).cleanupPartialRecord());
        BufferBuilderAndConsumerTest.assertContent(consumer3.build(), FreeingBufferRecycler.INSTANCE, 8, 9);
    }

    @Test
    public void partialLongRecordEndsWithFullBufferTestCase() {
        this.writeToBuffer(BufferBuilderAndConsumerTest.toByteBuffer(0, 1, 2, 3, 4, 5, 6, 42));
        this.writeToBuffer(BufferBuilderAndConsumerTest.toByteBuffer(8, 9));
        Assert.assertEquals((long)this.buffers.size(), (long)3L);
        this.buffers.poll();
        BufferConsumerWithPartialRecordLength consumer2 = (BufferConsumerWithPartialRecordLength)this.buffers.poll();
        Assert.assertEquals((long)16L, (long)Objects.requireNonNull(consumer2).getPartialRecordLength());
        Assert.assertFalse((boolean)consumer2.cleanupPartialRecord());
        Assert.assertEquals((long)consumer2.build().readableBytes(), (long)0L);
        BufferConsumerWithPartialRecordLength consumer3 = (BufferConsumerWithPartialRecordLength)this.buffers.poll();
        Assert.assertTrue((boolean)Objects.requireNonNull(consumer3).cleanupPartialRecord());
        BufferBuilderAndConsumerTest.assertContent(consumer3.build(), FreeingBufferRecycler.INSTANCE, 8, 9);
    }

    @Test
    public void readPositionNotAtTheBeginningOfTheBufferTestCase() {
        this.writeToBuffer(BufferBuilderAndConsumerTest.toByteBuffer(0, 1, 2, 3, 42));
        Assert.assertEquals((long)this.buffers.size(), (long)2L);
        this.buffers.poll();
        BufferConsumerWithPartialRecordLength consumer2 = (BufferConsumerWithPartialRecordLength)this.buffers.poll();
        Objects.requireNonNull(consumer2).build();
        this.writeToBuffer(BufferBuilderAndConsumerTest.toByteBuffer(8, 9));
        Assert.assertEquals((long)4L, (long)consumer2.getPartialRecordLength());
        Assert.assertTrue((boolean)consumer2.cleanupPartialRecord());
        BufferBuilderAndConsumerTest.assertContent(consumer2.build(), FreeingBufferRecycler.INSTANCE, 8, 9);
    }

    private void writeToBuffer(ByteBuffer record) {
        if (this.builder == null) {
            this.builder = this.createBufferBuilder();
            this.buffers.add((Object)new BufferConsumerWithPartialRecordLength(this.builder.createBufferConsumerFromBeginning(), 0));
        }
        this.builder.appendAndCommit(record);
        while (record.hasRemaining()) {
            this.builder.finish();
            this.builder = this.createBufferBuilder();
            int partialRecordBytes = this.builder.appendAndCommit(record);
            this.buffers.add((Object)new BufferConsumerWithPartialRecordLength(this.builder.createBufferConsumerFromBeginning(), partialRecordBytes));
        }
        if (this.builder.isFull()) {
            this.builder.finish();
            this.builder = null;
        }
    }

    private BufferBuilder createBufferBuilder() {
        return new BufferBuilder(MemorySegmentFactory.allocateUnpooledSegment((int)16), FreeingBufferRecycler.INSTANCE);
    }
}

