/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.junit.Assert;
import org.junit.Test;

public class BufferBuilderAndConsumerTest {
    private static final int BUFFER_INT_SIZE = 10;
    private static final int BUFFER_SIZE = 40;

    @Test
    public void referenceCounting() {
        BufferBuilder bufferBuilder = BufferBuilderAndConsumerTest.createBufferBuilder();
        BufferConsumer bufferConsumer = bufferBuilder.createBufferConsumer();
        Assert.assertEquals((long)12L, (long)bufferBuilder.appendAndCommit(BufferBuilderAndConsumerTest.toByteBuffer(1, 2, 3)));
        bufferBuilder.close();
        Buffer buffer = bufferConsumer.build();
        Assert.assertFalse((boolean)buffer.isRecycled());
        buffer.recycleBuffer();
        Assert.assertFalse((boolean)buffer.isRecycled());
        bufferConsumer.close();
        Assert.assertTrue((boolean)buffer.isRecycled());
    }

    @Test
    public void append() {
        BufferBuilder bufferBuilder = BufferBuilderAndConsumerTest.createBufferBuilder();
        BufferConsumer bufferConsumer = bufferBuilder.createBufferConsumer();
        int[] intsToWrite = new int[]{0, 1, 2, 3, 42};
        ByteBuffer bytesToWrite = BufferBuilderAndConsumerTest.toByteBuffer(intsToWrite);
        Assert.assertEquals((long)bytesToWrite.limit(), (long)bufferBuilder.appendAndCommit(bytesToWrite));
        Assert.assertEquals((long)bytesToWrite.limit(), (long)bytesToWrite.position());
        Assert.assertFalse((boolean)bufferBuilder.isFull());
        BufferBuilderAndConsumerTest.assertContent(bufferConsumer, intsToWrite);
    }

    @Test
    public void multipleAppends() {
        BufferBuilder bufferBuilder = BufferBuilderAndConsumerTest.createBufferBuilder();
        BufferConsumer bufferConsumer = bufferBuilder.createBufferConsumer();
        bufferBuilder.appendAndCommit(BufferBuilderAndConsumerTest.toByteBuffer(0, 1));
        bufferBuilder.appendAndCommit(BufferBuilderAndConsumerTest.toByteBuffer(2));
        bufferBuilder.appendAndCommit(BufferBuilderAndConsumerTest.toByteBuffer(3, 42));
        BufferBuilderAndConsumerTest.assertContent(bufferConsumer, 0, 1, 2, 3, 42);
    }

    @Test
    public void multipleNotCommittedAppends() {
        BufferBuilder bufferBuilder = BufferBuilderAndConsumerTest.createBufferBuilder();
        BufferConsumer bufferConsumer = bufferBuilder.createBufferConsumer();
        bufferBuilder.append(BufferBuilderAndConsumerTest.toByteBuffer(0, 1));
        bufferBuilder.append(BufferBuilderAndConsumerTest.toByteBuffer(2));
        bufferBuilder.append(BufferBuilderAndConsumerTest.toByteBuffer(3, 42));
        BufferBuilderAndConsumerTest.assertContent(bufferConsumer, new int[0]);
        bufferBuilder.commit();
        BufferBuilderAndConsumerTest.assertContent(bufferConsumer, 0, 1, 2, 3, 42);
    }

    @Test
    public void appendOverSize() {
        BufferBuilder bufferBuilder = BufferBuilderAndConsumerTest.createBufferBuilder();
        BufferConsumer bufferConsumer = bufferBuilder.createBufferConsumer();
        ByteBuffer bytesToWrite = BufferBuilderAndConsumerTest.toByteBuffer(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 42);
        Assert.assertEquals((long)40L, (long)bufferBuilder.appendAndCommit(bytesToWrite));
        Assert.assertTrue((boolean)bufferBuilder.isFull());
        BufferBuilderAndConsumerTest.assertContent(bufferConsumer, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        bufferBuilder = BufferBuilderAndConsumerTest.createBufferBuilder();
        bufferConsumer = bufferBuilder.createBufferConsumer();
        Assert.assertEquals((long)4L, (long)bufferBuilder.appendAndCommit(bytesToWrite));
        Assert.assertFalse((boolean)bufferBuilder.isFull());
        BufferBuilderAndConsumerTest.assertContent(bufferConsumer, 42);
    }

    @Test(expected=IllegalStateException.class)
    public void creatingBufferConsumerTwice() {
        BufferBuilder bufferBuilder = BufferBuilderAndConsumerTest.createBufferBuilder();
        bufferBuilder.createBufferConsumer();
        bufferBuilder.createBufferConsumer();
    }

    @Test
    public void copy() {
        BufferBuilder bufferBuilder = BufferBuilderAndConsumerTest.createBufferBuilder();
        BufferConsumer bufferConsumer1 = bufferBuilder.createBufferConsumer();
        bufferBuilder.appendAndCommit(BufferBuilderAndConsumerTest.toByteBuffer(0, 1));
        BufferConsumer bufferConsumer2 = bufferConsumer1.copy();
        bufferBuilder.appendAndCommit(BufferBuilderAndConsumerTest.toByteBuffer(2));
        BufferBuilderAndConsumerTest.assertContent(bufferConsumer1, 0, 1, 2);
        BufferBuilderAndConsumerTest.assertContent(bufferConsumer2, 0, 1, 2);
        BufferConsumer bufferConsumer3 = bufferConsumer1.copy();
        bufferBuilder.appendAndCommit(BufferBuilderAndConsumerTest.toByteBuffer(3, 42));
        BufferConsumer bufferConsumer4 = bufferConsumer1.copy();
        BufferBuilderAndConsumerTest.assertContent(bufferConsumer1, 3, 42);
        BufferBuilderAndConsumerTest.assertContent(bufferConsumer2, 3, 42);
        BufferBuilderAndConsumerTest.assertContent(bufferConsumer3, 3, 42);
        BufferBuilderAndConsumerTest.assertContent(bufferConsumer4, 3, 42);
    }

    @Test
    public void buildEmptyBuffer() {
        try (BufferBuilder bufferBuilder = BufferBuilderAndConsumerTest.createBufferBuilder();){
            Buffer buffer = BufferBuilderTestUtils.buildSingleBuffer(bufferBuilder);
            Assert.assertEquals((long)0L, (long)buffer.getSize());
            BufferBuilderAndConsumerTest.assertContent(buffer, FreeingBufferRecycler.INSTANCE, new int[0]);
        }
    }

    @Test
    public void buildingBufferMultipleTimes() {
        try (BufferBuilder bufferBuilder = BufferBuilderAndConsumerTest.createBufferBuilder();
             BufferConsumer bufferConsumer = bufferBuilder.createBufferConsumer();){
            bufferBuilder.appendAndCommit(BufferBuilderAndConsumerTest.toByteBuffer(0, 1));
            bufferBuilder.appendAndCommit(BufferBuilderAndConsumerTest.toByteBuffer(2));
            BufferBuilderAndConsumerTest.assertContent(bufferConsumer, 0, 1, 2);
            bufferBuilder.appendAndCommit(BufferBuilderAndConsumerTest.toByteBuffer(3, 42));
            bufferBuilder.appendAndCommit(BufferBuilderAndConsumerTest.toByteBuffer(44));
            BufferBuilderAndConsumerTest.assertContent(bufferConsumer, 3, 42, 44);
            ArrayList<Integer> originalValues = new ArrayList<Integer>();
            while (!bufferBuilder.isFull()) {
                bufferBuilder.appendAndCommit(BufferBuilderAndConsumerTest.toByteBuffer(1337));
                originalValues.add(1337);
            }
            BufferBuilderAndConsumerTest.assertContent(bufferConsumer, originalValues.stream().mapToInt(Integer::intValue).toArray());
        }
    }

    @Test
    public void emptyIsFinished() {
        BufferBuilderAndConsumerTest.testIsFinished(0);
    }

    @Test
    public void partiallyFullIsFinished() {
        BufferBuilderAndConsumerTest.testIsFinished(5);
    }

    @Test
    public void fullIsFinished() {
        BufferBuilderAndConsumerTest.testIsFinished(10);
    }

    @Test
    public void testWritableBytes() {
        BufferBuilder bufferBuilder = BufferBuilderAndConsumerTest.createBufferBuilder();
        Assert.assertEquals((long)bufferBuilder.getMaxCapacity(), (long)bufferBuilder.getWritableBytes());
        ByteBuffer byteBuffer = BufferBuilderAndConsumerTest.toByteBuffer(1, 2, 3);
        bufferBuilder.append(byteBuffer);
        Assert.assertEquals((long)(bufferBuilder.getMaxCapacity() - byteBuffer.position()), (long)bufferBuilder.getWritableBytes());
        Assert.assertEquals((long)(bufferBuilder.getMaxCapacity() - byteBuffer.position()), (long)bufferBuilder.getWritableBytes());
    }

    @Test
    public void testWritableBytesWhenFull() {
        BufferBuilder bufferBuilder = BufferBuilderAndConsumerTest.createBufferBuilder();
        bufferBuilder.append(BufferBuilderAndConsumerTest.toByteBuffer(new int[bufferBuilder.getMaxCapacity()]));
        Assert.assertEquals((long)0L, (long)bufferBuilder.getWritableBytes());
    }

    @Test
    public void recycleWithoutConsumer() {
        CountedRecycler recycler = new CountedRecycler();
        BufferBuilder bufferBuilder = new BufferBuilder(MemorySegmentFactory.allocateUnpooledSegment((int)40), (BufferRecycler)recycler);
        bufferBuilder.close();
        Assert.assertEquals((long)1L, (long)recycler.recycleInvocationCounter);
    }

    @Test
    public void recycleConsumerAndBufferBuilder() {
        CountedRecycler recycler = new CountedRecycler();
        BufferBuilder bufferBuilder = new BufferBuilder(MemorySegmentFactory.allocateUnpooledSegment((int)40), (BufferRecycler)recycler);
        BufferConsumer bufferConsumer = bufferBuilder.createBufferConsumer();
        bufferBuilder.close();
        Assert.assertEquals((long)0L, (long)recycler.recycleInvocationCounter);
        bufferConsumer.close();
        Assert.assertEquals((long)1L, (long)recycler.recycleInvocationCounter);
    }

    private static void testIsFinished(int writes) {
        BufferBuilder bufferBuilder = BufferBuilderAndConsumerTest.createBufferBuilder();
        BufferConsumer bufferConsumer = bufferBuilder.createBufferConsumer();
        for (int i = 0; i < writes; ++i) {
            Assert.assertEquals((long)4L, (long)bufferBuilder.appendAndCommit(BufferBuilderAndConsumerTest.toByteBuffer(42)));
        }
        int expectedWrittenBytes = writes * 4;
        Assert.assertFalse((boolean)bufferBuilder.isFinished());
        Assert.assertFalse((boolean)bufferConsumer.isFinished());
        Assert.assertEquals((long)0L, (long)bufferConsumer.getWrittenBytes());
        bufferConsumer.build();
        Assert.assertFalse((boolean)bufferBuilder.isFinished());
        Assert.assertFalse((boolean)bufferConsumer.isFinished());
        Assert.assertEquals((long)expectedWrittenBytes, (long)bufferConsumer.getWrittenBytes());
        int actualWrittenBytes = bufferBuilder.finish();
        Assert.assertEquals((long)expectedWrittenBytes, (long)actualWrittenBytes);
        Assert.assertTrue((boolean)bufferBuilder.isFinished());
        Assert.assertFalse((boolean)bufferConsumer.isFinished());
        Assert.assertEquals((long)expectedWrittenBytes, (long)bufferConsumer.getWrittenBytes());
        actualWrittenBytes = bufferBuilder.finish();
        Assert.assertEquals((long)expectedWrittenBytes, (long)actualWrittenBytes);
        Assert.assertTrue((boolean)bufferBuilder.isFinished());
        Assert.assertFalse((boolean)bufferConsumer.isFinished());
        Assert.assertEquals((long)expectedWrittenBytes, (long)bufferConsumer.getWrittenBytes());
        Assert.assertEquals((long)0L, (long)bufferConsumer.build().getSize());
        Assert.assertTrue((boolean)bufferConsumer.isFinished());
    }

    public static ByteBuffer toByteBuffer(int ... data) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(data.length * 4);
        byteBuffer.asIntBuffer().put(data);
        return byteBuffer;
    }

    private static void assertContent(BufferConsumer actualConsumer, int ... expected) {
        Assert.assertFalse((boolean)actualConsumer.isFinished());
        Buffer buffer = actualConsumer.build();
        Assert.assertFalse((boolean)buffer.isRecycled());
        BufferBuilderAndConsumerTest.assertContent(buffer, FreeingBufferRecycler.INSTANCE, expected);
        Assert.assertEquals((long)(expected.length * 4), (long)buffer.getSize());
        buffer.recycleBuffer();
    }

    public static void assertContent(Buffer actualBuffer, @Nullable BufferRecycler recycler, int ... expected) {
        IntBuffer actualIntBuffer = actualBuffer.getNioBufferReadable().asIntBuffer();
        int[] actual = new int[actualIntBuffer.limit()];
        actualIntBuffer.get(actual);
        Assert.assertArrayEquals((int[])expected, (int[])actual);
        if (recycler != null) {
            Assert.assertEquals((Object)recycler, (Object)actualBuffer.getRecycler());
        }
    }

    private static BufferBuilder createBufferBuilder() {
        return new BufferBuilder(MemorySegmentFactory.allocateUnpooledSegment((int)40), FreeingBufferRecycler.INSTANCE);
    }

    private static class CountedRecycler
    implements BufferRecycler {
        int recycleInvocationCounter;

        private CountedRecycler() {
        }

        public void recycle(MemorySegment memorySegment) {
            ++this.recycleInvocationCounter;
            memorySegment.free();
        }
    }
}

