/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.nonha.standalone;

import java.util.UUID;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.nonha.standalone.StandaloneHaServices;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class StandaloneHaServicesTest
extends TestLogger {
    private final String dispatcherAddress = "dispatcher";
    private final String resourceManagerAddress = "resourceManager";
    private final String webMonitorAddress = "webMonitor";
    private StandaloneHaServices standaloneHaServices;

    @Before
    public void setupTest() {
        this.standaloneHaServices = new StandaloneHaServices("resourceManager", "dispatcher", "webMonitor");
    }

    @After
    public void teardownTest() throws Exception {
        if (this.standaloneHaServices != null) {
            this.standaloneHaServices.closeAndCleanupAllData();
            this.standaloneHaServices = null;
        }
    }

    @Test
    public void testLeaderElection() throws Exception {
        JobID jobId = new JobID();
        LeaderContender jmLeaderContender = (LeaderContender)Mockito.mock(LeaderContender.class);
        LeaderContender rmLeaderContender = (LeaderContender)Mockito.mock(LeaderContender.class);
        LeaderElectionService jmLeaderElectionService = this.standaloneHaServices.getJobManagerLeaderElectionService(jobId);
        LeaderElectionService rmLeaderElectionService = this.standaloneHaServices.getResourceManagerLeaderElectionService();
        jmLeaderElectionService.start(jmLeaderContender);
        rmLeaderElectionService.start(rmLeaderContender);
        ((LeaderContender)Mockito.verify((Object)jmLeaderContender)).grantLeadership((UUID)Matchers.eq((Object)HighAvailabilityServices.DEFAULT_LEADER_ID));
        ((LeaderContender)Mockito.verify((Object)rmLeaderContender)).grantLeadership((UUID)Matchers.eq((Object)HighAvailabilityServices.DEFAULT_LEADER_ID));
    }

    @Test
    public void testJobManagerLeaderRetrieval() throws Exception {
        JobID jobId1 = new JobID();
        JobID jobId2 = new JobID();
        LeaderRetrievalListener jmListener1 = (LeaderRetrievalListener)Mockito.mock(LeaderRetrievalListener.class);
        LeaderRetrievalListener jmListener2 = (LeaderRetrievalListener)Mockito.mock(LeaderRetrievalListener.class);
        LeaderRetrievalListener rmListener = (LeaderRetrievalListener)Mockito.mock(LeaderRetrievalListener.class);
        LeaderRetrievalService jmLeaderRetrievalService1 = this.standaloneHaServices.getJobManagerLeaderRetriever(jobId1);
        LeaderRetrievalService jmLeaderRetrievalService2 = this.standaloneHaServices.getJobManagerLeaderRetriever(jobId2);
        LeaderRetrievalService rmLeaderRetrievalService = this.standaloneHaServices.getResourceManagerLeaderRetriever();
        jmLeaderRetrievalService1.start(jmListener1);
        jmLeaderRetrievalService2.start(jmListener2);
        rmLeaderRetrievalService.start(rmListener);
        ((LeaderRetrievalListener)Mockito.verify((Object)jmListener1)).notifyLeaderAddress((String)Matchers.eq((Object)"UNKNOWN"), (UUID)Matchers.eq((Object)HighAvailabilityServices.DEFAULT_LEADER_ID));
        ((LeaderRetrievalListener)Mockito.verify((Object)jmListener2)).notifyLeaderAddress((String)Matchers.eq((Object)"UNKNOWN"), (UUID)Matchers.eq((Object)HighAvailabilityServices.DEFAULT_LEADER_ID));
        ((LeaderRetrievalListener)Mockito.verify((Object)rmListener)).notifyLeaderAddress((String)Matchers.eq((Object)"resourceManager"), (UUID)Matchers.eq((Object)HighAvailabilityServices.DEFAULT_LEADER_ID));
    }

    @Test
    public void testJobMasterLeaderRetrieval() throws Exception {
        JobID jobId1 = new JobID();
        JobID jobId2 = new JobID();
        String jobManagerAddress1 = "foobar";
        String jobManagerAddress2 = "barfoo";
        LeaderRetrievalListener jmListener1 = (LeaderRetrievalListener)Mockito.mock(LeaderRetrievalListener.class);
        LeaderRetrievalListener jmListener2 = (LeaderRetrievalListener)Mockito.mock(LeaderRetrievalListener.class);
        LeaderRetrievalService jmLeaderRetrievalService1 = this.standaloneHaServices.getJobManagerLeaderRetriever(jobId1, "foobar");
        LeaderRetrievalService jmLeaderRetrievalService2 = this.standaloneHaServices.getJobManagerLeaderRetriever(jobId2, "barfoo");
        jmLeaderRetrievalService1.start(jmListener1);
        jmLeaderRetrievalService2.start(jmListener2);
        ((LeaderRetrievalListener)Mockito.verify((Object)jmListener1)).notifyLeaderAddress((String)Matchers.eq((Object)"foobar"), (UUID)Matchers.eq((Object)HighAvailabilityServices.DEFAULT_LEADER_ID));
        ((LeaderRetrievalListener)Mockito.verify((Object)jmListener2)).notifyLeaderAddress((String)Matchers.eq((Object)"barfoo"), (UUID)Matchers.eq((Object)HighAvailabilityServices.DEFAULT_LEADER_ID));
    }
}

