/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.scheduler.DefaultScheduler;
import org.apache.flink.runtime.scheduler.SchedulerTestingUtils;
import org.apache.flink.runtime.testtasks.NoOpInvokable;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FinalizeOnMasterTest
extends TestLogger {
    @Test
    public void testFinalizeIsCalledUponSuccess() throws Exception {
        JobVertex vertex1 = (JobVertex)Mockito.spy((Object)new JobVertex("test vertex 1"));
        vertex1.setInvokableClass(NoOpInvokable.class);
        vertex1.setParallelism(3);
        JobVertex vertex2 = (JobVertex)Mockito.spy((Object)new JobVertex("test vertex 2"));
        vertex2.setInvokableClass(NoOpInvokable.class);
        vertex2.setParallelism(2);
        DefaultScheduler scheduler = SchedulerTestingUtils.createScheduler(JobGraphTestUtils.streamingJobGraph(vertex1, vertex2), ComponentMainThreadExecutorServiceAdapter.forMainThread());
        scheduler.startScheduling();
        ExecutionGraph eg = scheduler.getExecutionGraph();
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)eg.getState());
        ExecutionGraphTestUtils.switchAllVerticesToRunning(eg);
        ExecutionGraphTestUtils.finishAllVertices(eg);
        Assert.assertEquals((Object)JobStatus.FINISHED, (Object)eg.waitUntilTerminal());
        ((JobVertex)Mockito.verify((Object)vertex1, (VerificationMode)Mockito.times((int)1))).finalizeOnMaster((ClassLoader)Mockito.any(ClassLoader.class));
        ((JobVertex)Mockito.verify((Object)vertex2, (VerificationMode)Mockito.times((int)1))).finalizeOnMaster((ClassLoader)Mockito.any(ClassLoader.class));
        Assert.assertEquals((long)0L, (long)eg.getRegisteredExecutions().size());
    }

    @Test
    public void testFinalizeIsNotCalledUponFailure() throws Exception {
        JobVertex vertex = (JobVertex)Mockito.spy((Object)new JobVertex("test vertex 1"));
        vertex.setInvokableClass(NoOpInvokable.class);
        vertex.setParallelism(1);
        DefaultScheduler scheduler = SchedulerTestingUtils.createScheduler(JobGraphTestUtils.streamingJobGraph(vertex), ComponentMainThreadExecutorServiceAdapter.forMainThread());
        scheduler.startScheduling();
        ExecutionGraph eg = scheduler.getExecutionGraph();
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)eg.getState());
        ExecutionGraphTestUtils.switchAllVerticesToRunning(eg);
        Execution exec = eg.getJobVertex(vertex.getID()).getTaskVertices()[0].getCurrentExecutionAttempt();
        exec.fail((Throwable)new Exception("test"));
        Assert.assertEquals((Object)JobStatus.FAILED, (Object)eg.waitUntilTerminal());
        ((JobVertex)Mockito.verify((Object)vertex, (VerificationMode)Mockito.times((int)0))).finalizeOnMaster((ClassLoader)Mockito.any(ClassLoader.class));
        Assert.assertEquals((long)0L, (long)eg.getRegisteredExecutions().size());
    }
}

