/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint.component;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponent;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;

public class TestingResourceManagerService
implements DispatcherResourceManagerComponent.ResourceManagerService {
    private final ResourceManagerGateway resourceManagerGateway;
    private final CompletableFuture<Void> terminationFuture;
    private final boolean completeTerminationFutureOnClose;

    private TestingResourceManagerService(ResourceManagerGateway resourceManagerGateway, CompletableFuture<Void> terminationFuture, boolean completeTerminationFutureOnClose) {
        this.resourceManagerGateway = resourceManagerGateway;
        this.terminationFuture = terminationFuture;
        this.completeTerminationFutureOnClose = completeTerminationFutureOnClose;
    }

    public ResourceManagerGateway getGateway() {
        return this.resourceManagerGateway;
    }

    public CompletableFuture<Void> getTerminationFuture() {
        return this.terminationFuture;
    }

    public CompletableFuture<Void> closeAsync() {
        if (this.completeTerminationFutureOnClose) {
            this.terminationFuture.complete(null);
        }
        return this.getTerminationFuture();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private ResourceManagerGateway resourceManagerGateway = new TestingResourceManagerGateway();
        private CompletableFuture<Void> terminationFuture = new CompletableFuture();
        private boolean completeTerminationFutureOnClose = true;

        public Builder setResourceManagerGateway(ResourceManagerGateway resourceManagerGateway) {
            this.resourceManagerGateway = resourceManagerGateway;
            return this;
        }

        public Builder setTerminationFuture(CompletableFuture<Void> terminationFuture) {
            this.terminationFuture = terminationFuture;
            return this;
        }

        public Builder withManualTerminationFutureCompletion() {
            this.completeTerminationFutureOnClose = false;
            return this;
        }

        public TestingResourceManagerService build() {
            return new TestingResourceManagerService(this.resourceManagerGateway, this.terminationFuture, this.completeTerminationFutureOnClose);
        }
    }
}

