/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.runtime.checkpoint.MinMaxAvgStats;
import org.junit.Assert;
import org.junit.Test;

public class MinMaxAvgStatsTest {
    @Test
    public void testInitialState() throws Exception {
        MinMaxAvgStats mma = new MinMaxAvgStats();
        Assert.assertEquals((long)0L, (long)mma.getMinimum());
        Assert.assertEquals((long)0L, (long)mma.getMaximum());
        Assert.assertEquals((long)0L, (long)mma.getSum());
        Assert.assertEquals((long)0L, (long)mma.getCount());
        Assert.assertEquals((long)0L, (long)mma.getAverage());
    }

    @Test
    public void testAddNonPositiveStats() throws Exception {
        MinMaxAvgStats mma = new MinMaxAvgStats();
        mma.add(-1L);
        Assert.assertEquals((long)0L, (long)mma.getMinimum());
        Assert.assertEquals((long)0L, (long)mma.getMaximum());
        Assert.assertEquals((long)0L, (long)mma.getSum());
        Assert.assertEquals((long)0L, (long)mma.getCount());
        Assert.assertEquals((long)0L, (long)mma.getAverage());
        mma.add(0L);
        Assert.assertEquals((long)0L, (long)mma.getMinimum());
        Assert.assertEquals((long)0L, (long)mma.getMaximum());
        Assert.assertEquals((long)0L, (long)mma.getSum());
        Assert.assertEquals((long)1L, (long)mma.getCount());
        Assert.assertEquals((long)0L, (long)mma.getAverage());
    }

    @Test
    public void testAddRandomNumbers() throws Exception {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        MinMaxAvgStats mma = new MinMaxAvgStats();
        long count = 13L;
        long sum = 0L;
        long min = Integer.MAX_VALUE;
        long max = Integer.MIN_VALUE;
        int i = 0;
        while ((long)i < count) {
            int number = rand.nextInt(124) + 1;
            sum += (long)number;
            min = Math.min(min, (long)number);
            max = Math.max(max, (long)number);
            mma.add((long)number);
            ++i;
        }
        Assert.assertEquals((long)min, (long)mma.getMinimum());
        Assert.assertEquals((long)max, (long)mma.getMaximum());
        Assert.assertEquals((long)sum, (long)mma.getSum());
        Assert.assertEquals((long)count, (long)mma.getCount());
        Assert.assertEquals((long)(sum / count), (long)mma.getAverage());
    }
}

