/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.function.SupplierWithException;

final class BackgroundTask<T> {
    private final CompletableFuture<Void> terminationFuture;
    private final CompletableFuture<T> resultFuture;
    private volatile boolean isAborted = false;

    private BackgroundTask(CompletableFuture<Void> previousTerminationFuture, SupplierWithException<? extends T, ? extends Exception> task, Executor executor) {
        this.resultFuture = previousTerminationFuture.thenApplyAsync(ignored -> {
            if (!this.isAborted) {
                try {
                    return task.get();
                }
                catch (Exception exception) {
                    throw new CompletionException(exception);
                }
            }
            throw new CompletionException(new FlinkException("Background task has been aborted."));
        }, executor);
        this.terminationFuture = this.resultFuture.handle((ignored, ignoredThrowable) -> null);
    }

    private BackgroundTask() {
        this.terminationFuture = FutureUtils.completedVoidFuture();
        this.resultFuture = FutureUtils.completedExceptionally(new FlinkException("No result has been created because it is a finished background task."));
    }

    void abort() {
        this.isAborted = true;
    }

    public CompletableFuture<T> getResultFuture() {
        return this.resultFuture;
    }

    CompletableFuture<Void> getTerminationFuture() {
        return this.terminationFuture;
    }

    <V> BackgroundTask<V> runAfter(SupplierWithException<? extends V, ? extends Exception> task, Executor executor) {
        return new BackgroundTask<V>(this.terminationFuture, task, executor);
    }

    static <V> BackgroundTask<V> finishedBackgroundTask() {
        return new BackgroundTask();
    }

    static <V> BackgroundTask<V> initialBackgroundTask(SupplierWithException<? extends V, ? extends Exception> task, Executor executor) {
        return new BackgroundTask<V>(FutureUtils.completedVoidFuture(), task, executor);
    }
}

