/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.reader;

import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.reader.AbstractRecordReader;
import org.apache.flink.runtime.io.network.api.reader.Reader;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;

public class RecordReader<T extends IOReadableWritable>
extends AbstractRecordReader<T>
implements Reader<T> {
    private final Class<T> recordType;
    private T currentRecord;

    public RecordReader(InputGate inputGate, Class<T> recordType, String[] tmpDirectories) {
        super(inputGate, tmpDirectories);
        this.recordType = recordType;
    }

    @Override
    public boolean hasNext() throws IOException, InterruptedException {
        if (this.currentRecord != null) {
            return true;
        }
        T record = this.instantiateRecordType();
        if (this.getNextRecord(record)) {
            this.currentRecord = record;
            return true;
        }
        return false;
    }

    @Override
    public T next() throws IOException, InterruptedException {
        if (this.hasNext()) {
            T tmp = this.currentRecord;
            this.currentRecord = null;
            return tmp;
        }
        return null;
    }

    @Override
    public void clearBuffers() {
        super.clearBuffers();
    }

    private T instantiateRecordType() {
        try {
            return (T)((IOReadableWritable)this.recordType.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Cannot instantiate class " + this.recordType.getName(), e);
        }
    }
}

