/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;

public class ExecutionAttemptMappingProvider {
    private final List<ExecutionVertex> tasks = new ArrayList<ExecutionVertex>();
    private final LinkedHashMap<ExecutionAttemptID, ExecutionVertex> cachedTasksById;

    public ExecutionAttemptMappingProvider(Iterable<ExecutionVertex> tasksIterable) {
        tasksIterable.forEach(this.tasks::add);
        this.cachedTasksById = new LinkedHashMap<ExecutionAttemptID, ExecutionVertex>(this.tasks.size()){

            @Override
            protected boolean removeEldestEntry(Map.Entry<ExecutionAttemptID, ExecutionVertex> eldest) {
                return this.size() > ExecutionAttemptMappingProvider.this.tasks.size();
            }
        };
    }

    public Optional<ExecutionVertex> getVertex(ExecutionAttemptID id) {
        if (!this.cachedTasksById.containsKey(id)) {
            this.cachedTasksById.putAll(this.getCurrentAttemptMappings());
            if (!this.cachedTasksById.containsKey(id)) {
                this.cachedTasksById.put(id, null);
            }
        }
        return Optional.ofNullable(this.cachedTasksById.get(id));
    }

    private Map<ExecutionAttemptID, ExecutionVertex> getCurrentAttemptMappings() {
        HashMap<ExecutionAttemptID, ExecutionVertex> attemptMappings = new HashMap<ExecutionAttemptID, ExecutionVertex>(this.tasks.size());
        for (ExecutionVertex task : this.tasks) {
            attemptMappings.put(task.getCurrentExecutionAttempt().getAttemptId(), task);
        }
        return attemptMappings;
    }
}

