/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.org.apache.curator.framework.state;

import java.io.Closeable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.shaded.com.google.common.base.Function;
import org.apache.flink.shaded.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.org.apache.curator.framework.listen.ListenerContainer;
import org.apache.flink.shaded.org.apache.curator.framework.state.ConnectionState;
import org.apache.flink.shaded.org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.flink.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.flink.shaded.org.apache.curator.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionStateManager
implements Closeable {
    private static final int QUEUE_SIZE;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final BlockingQueue<ConnectionState> eventQueue = new ArrayBlockingQueue<ConnectionState>(QUEUE_SIZE);
    private final CuratorFramework client;
    private final ListenerContainer<ConnectionStateListener> listeners = new ListenerContainer();
    private final AtomicBoolean initialConnectMessageSent = new AtomicBoolean(false);
    private final ExecutorService service;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private ConnectionState currentConnectionState;

    public ConnectionStateManager(CuratorFramework client, ThreadFactory threadFactory) {
        this.client = client;
        if (threadFactory == null) {
            threadFactory = ThreadUtils.newThreadFactory("ConnectionStateManager");
        }
        this.service = Executors.newSingleThreadExecutor(threadFactory);
    }

    public void start() {
        Preconditions.checkState(this.state.compareAndSet(State.LATENT, State.STARTED), "Cannot be started more than once");
        this.service.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ConnectionStateManager.this.processEvents();
                return null;
            }
        });
    }

    @Override
    public void close() {
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            this.service.shutdownNow();
            this.listeners.clear();
        }
    }

    public ListenerContainer<ConnectionStateListener> getListenable() {
        return this.listeners;
    }

    public synchronized boolean setToSuspended() {
        if (this.state.get() != State.STARTED) {
            return false;
        }
        if (this.currentConnectionState == ConnectionState.LOST || this.currentConnectionState == ConnectionState.SUSPENDED) {
            return false;
        }
        this.currentConnectionState = ConnectionState.SUSPENDED;
        this.postState(ConnectionState.SUSPENDED);
        return true;
    }

    public synchronized boolean addStateChange(ConnectionState newConnectionState) {
        boolean isNegativeMessage;
        if (this.state.get() != State.STARTED) {
            return false;
        }
        ConnectionState previousState = this.currentConnectionState;
        if (previousState == newConnectionState) {
            return false;
        }
        this.currentConnectionState = newConnectionState;
        ConnectionState localState = newConnectionState;
        boolean bl = isNegativeMessage = newConnectionState == ConnectionState.LOST || newConnectionState == ConnectionState.SUSPENDED || newConnectionState == ConnectionState.READ_ONLY;
        if (!isNegativeMessage && this.initialConnectMessageSent.compareAndSet(false, true)) {
            localState = ConnectionState.CONNECTED;
        }
        this.postState(localState);
        return true;
    }

    public synchronized boolean blockUntilConnected(int maxWaitTime, TimeUnit units) throws InterruptedException {
        long maxWaitTimeMs;
        long startTime = System.currentTimeMillis();
        boolean hasMaxWait = units != null;
        long l = maxWaitTimeMs = hasMaxWait ? TimeUnit.MILLISECONDS.convert(maxWaitTime, units) : 0L;
        while (!this.isConnected()) {
            if (hasMaxWait) {
                long waitTime = maxWaitTimeMs - (System.currentTimeMillis() - startTime);
                if (waitTime <= 0L) {
                    return this.isConnected();
                }
                this.wait(waitTime);
                continue;
            }
            this.wait();
        }
        return this.isConnected();
    }

    public synchronized boolean isConnected() {
        return this.currentConnectionState != null && this.currentConnectionState.isConnected();
    }

    private void postState(ConnectionState state) {
        this.log.info("State change: " + (Object)((Object)state));
        this.notifyAll();
        while (!this.eventQueue.offer(state)) {
            this.eventQueue.poll();
            this.log.warn("ConnectionStateManager queue full - dropping events to make room");
        }
    }

    private void processEvents() {
        while (this.state.get() == State.STARTED) {
            try {
                final ConnectionState newState = this.eventQueue.take();
                if (this.listeners.size() == 0) {
                    this.log.warn("There are no ConnectionStateListeners registered.");
                }
                this.listeners.forEach(new Function<ConnectionStateListener, Void>(){

                    @Override
                    public Void apply(ConnectionStateListener listener) {
                        listener.stateChanged(ConnectionStateManager.this.client, newState);
                        return null;
                    }
                });
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static {
        int size = 25;
        String property = System.getProperty("ConnectionStateManagerSize", null);
        if (property != null) {
            try {
                size = Integer.parseInt(property);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        QUEUE_SIZE = size;
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

