/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.org.apache.curator.framework.imps;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.shaded.org.apache.curator.RetryLoop;
import org.apache.flink.shaded.org.apache.curator.framework.api.Pathable;
import org.apache.flink.shaded.org.apache.curator.framework.api.transaction.CuratorTransaction;
import org.apache.flink.shaded.org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.flink.shaded.org.apache.curator.framework.api.transaction.CuratorTransactionFinal;
import org.apache.flink.shaded.org.apache.curator.framework.api.transaction.CuratorTransactionResult;
import org.apache.flink.shaded.org.apache.curator.framework.api.transaction.OperationType;
import org.apache.flink.shaded.org.apache.curator.framework.api.transaction.TransactionCheckBuilder;
import org.apache.flink.shaded.org.apache.curator.framework.api.transaction.TransactionCreateBuilder;
import org.apache.flink.shaded.org.apache.curator.framework.api.transaction.TransactionDeleteBuilder;
import org.apache.flink.shaded.org.apache.curator.framework.api.transaction.TransactionSetDataBuilder;
import org.apache.flink.shaded.org.apache.curator.framework.imps.CreateBuilderImpl;
import org.apache.flink.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.flink.shaded.org.apache.curator.framework.imps.CuratorMultiTransactionRecord;
import org.apache.flink.shaded.org.apache.curator.framework.imps.DeleteBuilderImpl;
import org.apache.flink.shaded.org.apache.curator.framework.imps.SetDataBuilderImpl;
import org.apache.flink.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.flink.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.data.Stat;

class CuratorTransactionImpl
implements CuratorTransaction,
CuratorTransactionBridge,
CuratorTransactionFinal {
    private final CuratorFrameworkImpl client;
    private final CuratorMultiTransactionRecord transaction;
    private boolean isCommitted = false;

    CuratorTransactionImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.transaction = new CuratorMultiTransactionRecord();
    }

    @Override
    public CuratorTransactionFinal and() {
        return this;
    }

    @Override
    public TransactionCreateBuilder create() {
        Preconditions.checkState(!this.isCommitted, "transaction already committed");
        return new CreateBuilderImpl(this.client).asTransactionCreateBuilder(this, this.transaction);
    }

    @Override
    public TransactionDeleteBuilder delete() {
        Preconditions.checkState(!this.isCommitted, "transaction already committed");
        return new DeleteBuilderImpl(this.client).asTransactionDeleteBuilder(this, this.transaction);
    }

    @Override
    public TransactionSetDataBuilder setData() {
        Preconditions.checkState(!this.isCommitted, "transaction already committed");
        return new SetDataBuilderImpl(this.client).asTransactionSetDataBuilder(this, this.transaction);
    }

    @Override
    public TransactionCheckBuilder check() {
        Preconditions.checkState(!this.isCommitted, "transaction already committed");
        return new TransactionCheckBuilder(){
            private int version = -1;

            @Override
            public CuratorTransactionBridge forPath(String path) throws Exception {
                String fixedPath = CuratorTransactionImpl.this.client.fixForNamespace(path);
                CuratorTransactionImpl.this.transaction.add(Op.check((String)fixedPath, (int)this.version), OperationType.CHECK, path);
                return CuratorTransactionImpl.this;
            }

            @Override
            public Pathable<CuratorTransactionBridge> withVersion(int version) {
                this.version = version;
                return this;
            }
        };
    }

    @Override
    public Collection<CuratorTransactionResult> commit() throws Exception {
        Preconditions.checkState(!this.isCommitted, "transaction already committed");
        this.isCommitted = true;
        final AtomicBoolean firstTime = new AtomicBoolean(true);
        List<OpResult> resultList = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<List<OpResult>>(){

            @Override
            public List<OpResult> call() throws Exception {
                return CuratorTransactionImpl.this.doOperation(firstTime);
            }
        });
        if (resultList.size() != this.transaction.metadataSize()) {
            throw new IllegalStateException(String.format("Result size (%d) doesn't match input size (%d)", resultList.size(), this.transaction.metadataSize()));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < resultList.size(); ++i) {
            OpResult opResult = resultList.get(i);
            CuratorMultiTransactionRecord.TypeAndPath metadata = this.transaction.getMetadata(i);
            CuratorTransactionResult curatorResult = this.makeCuratorResult(opResult, metadata);
            builder.add(curatorResult);
        }
        return builder.build();
    }

    private List<OpResult> doOperation(AtomicBoolean firstTime) throws Exception {
        OpResult firstResult;
        List opResults;
        boolean localFirstTime = firstTime.getAndSet(false);
        if (!localFirstTime) {
            // empty if block
        }
        if ((opResults = this.client.getZooKeeper().multi((Iterable)((Object)this.transaction))).size() > 0 && (firstResult = (OpResult)opResults.get(0)).getType() == -1) {
            OpResult.ErrorResult error = (OpResult.ErrorResult)firstResult;
            KeeperException.Code code = KeeperException.Code.get((int)error.getErr());
            if (code == null) {
                code = KeeperException.Code.UNIMPLEMENTED;
            }
            throw KeeperException.create((KeeperException.Code)code);
        }
        return opResults;
    }

    private CuratorTransactionResult makeCuratorResult(OpResult opResult, CuratorMultiTransactionRecord.TypeAndPath metadata) {
        String resultPath = null;
        Stat resultStat = null;
        switch (opResult.getType()) {
            default: {
                break;
            }
            case 1: {
                OpResult.CreateResult createResult = (OpResult.CreateResult)opResult;
                resultPath = this.client.unfixForNamespace(createResult.getPath());
                break;
            }
            case 5: {
                OpResult.SetDataResult setDataResult = (OpResult.SetDataResult)opResult;
                resultStat = setDataResult.getStat();
                break;
            }
        }
        return new CuratorTransactionResult(metadata.type, metadata.forPath, resultPath, resultStat);
    }
}

