/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.util.FatalExitExceptionHandler;
import org.apache.flink.util.Preconditions;

public class ExecutorThreadFactory
implements ThreadFactory {
    private static final String DEFAULT_POOL_NAME = "flink-executor-pool";
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final String namePrefix;
    private final Thread.UncaughtExceptionHandler exceptionHandler;

    public ExecutorThreadFactory() {
        this(DEFAULT_POOL_NAME);
    }

    public ExecutorThreadFactory(String poolName) {
        this(poolName, FatalExitExceptionHandler.INSTANCE);
    }

    public ExecutorThreadFactory(String poolName, Thread.UncaughtExceptionHandler exceptionHandler) {
        Preconditions.checkNotNull((Object)poolName, (String)"poolName");
        SecurityManager securityManager = System.getSecurityManager();
        this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = poolName + "-thread-";
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread t = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement());
        t.setDaemon(true);
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        if (this.exceptionHandler != null) {
            t.setUncaughtExceptionHandler(this.exceptionHandler);
        }
        return t;
    }
}

